/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import org.eclipse.jface.databinding.viewers.IViewerUpdater;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class ViewerUpdater
implements IViewerUpdater {
    private final StructuredViewer viewer;

    protected ViewerUpdater(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public abstract void insert(Object var1, int var2);

    @Override
    public abstract void remove(Object var1, int var2);

    @Override
    public void replace(Object oldElement, Object newElement, int position) {
        this.remove(oldElement, position);
        this.insert(newElement, position);
    }

    @Override
    public void move(Object element, int oldPosition, int newPosition) {
        if (this.isElementOrderPreserved()) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            this.remove(element, oldPosition);
            this.insert(element, newPosition);
            if (this.selectionContains(selection, element)) {
                this.viewer.setSelection((ISelection)selection);
            }
        }
    }

    boolean isElementOrderPreserved() {
        return this.viewer.getComparator() == null && this.viewer.getFilters().length == 0;
    }

    private boolean selectionContains(IStructuredSelection selection, Object element) {
        if (!selection.isEmpty()) {
            IElementComparer comparer = this.viewer.getComparer();
            for (Object selectionElement : selection) {
                if (!(comparer == null ? Util.equals((Object)element, selectionElement) : comparer.equals(element, selectionElement))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract void add(Object[] var1);

    @Override
    public abstract void remove(Object[] var1);
}

