/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.util;

import java.util.Objects;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.scout.sdk.core.util.Strings;

public class NormalizedPattern {
    private static final char END_SYMBOL = '<';
    private static final char ANY_STRING = '*';
    private static final char ANY_CHAR = '?';
    private static final char BLANK = ' ';
    private final int m_matchRule;
    private final String m_pattern;

    public static NormalizedPattern build(String searchString) {
        if (Strings.isBlank((CharSequence)searchString)) {
            return new NormalizedPattern(Character.toString('*'), 2);
        }
        int length = searchString.length();
        char last = searchString.charAt(length - 1);
        if (searchString.indexOf(42) != -1 || searchString.indexOf(63) != -1) {
            switch (last) {
                case ' ': 
                case '<': {
                    return new NormalizedPattern(searchString.substring(0, length - 1), 2);
                }
                case '*': {
                    return new NormalizedPattern(searchString, 2);
                }
            }
            return new NormalizedPattern(String.valueOf(searchString) + '*', 2);
        }
        if (last == '<' || last == ' ') {
            if (SearchPattern.validateMatchRule((String)(searchString = searchString.substring(0, length - 1)), (int)256) == 256) {
                return new NormalizedPattern(searchString, 256);
            }
            return new NormalizedPattern(searchString, 0);
        }
        if (SearchPattern.validateMatchRule((String)searchString, (int)128) == 128) {
            return new NormalizedPattern(searchString, 128);
        }
        return new NormalizedPattern(searchString, 1);
    }

    public boolean isEmpty() {
        String pattern = this.getPattern();
        if (Strings.isBlank((CharSequence)pattern)) {
            return true;
        }
        int i = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) != '*' && pattern.charAt(i) != '?') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] getMatchingRegions(String elementText) {
        if (elementText == null) {
            return null;
        }
        return SearchPattern.getMatchingRegions((String)this.getPattern(), (String)elementText, (int)this.getMatchRule());
    }

    public boolean matches(String elementText) {
        return this.getMatchingRegions(elementText) != null;
    }

    protected NormalizedPattern(String pattern, int matchRule) {
        this.m_pattern = pattern;
        this.m_matchRule = matchRule;
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public int getMatchRule() {
        return this.m_matchRule;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NormalizedPattern [Pattern=").append(this.getPattern()).append(", MatchRule=").append(this.getMatchRule()).append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.m_matchRule;
        result = prime * result + (this.m_pattern == null ? 0 : this.m_pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NormalizedPattern other = (NormalizedPattern)obj;
        return this.m_matchRule == other.m_matchRule && Objects.equals(this.m_pattern, other.m_pattern);
    }
}

