/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.sirius.common.ui.Messages;
import org.eclipse.sirius.common.ui.tools.api.dialog.quickoutline.IQuickOutlineLabelProvider;

public class QuickOutlineAdapterFactoryLabelProvider
extends AdapterFactoryLabelProvider
implements IQuickOutlineLabelProvider {
    private Multimap<Object, String> multimap = HashMultimap.create();

    public QuickOutlineAdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object element) {
        StringBuilder sb = new StringBuilder(super.getText(element));
        if (this.multimap.containsKey(element)) {
            sb.append(" (").append(Messages.QuickOutlineAdapterFactoryLabelProvider_foundIn).append(" ");
            sb.append(Joiner.on((String)", ").join(this.multimap.get(element).toArray()));
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public void addMatch(Object matchingElement, String attributeName) {
        this.multimap.put(matchingElement, (Object)attributeName);
    }

    @Override
    public void clear() {
        this.multimap.clear();
    }
}

