/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;

public final class StatusHelper {
    public static final IStatus getStatus(Throwable error) {
        String message;
        if (error == null) {
            return Status.OK_STATUS;
        }
        int severity = 4;
        if (error instanceof CoreException && ((CoreException)error).getStatus() != null) {
            return ((CoreException)error).getStatus();
        }
        if (error instanceof OperationCanceledException) {
            severity = 8;
        }
        if ((message = error.getLocalizedMessage()) == null) {
            message = error.getMessage();
        }
        message = StatusHelper.unwrapErrorReport(message);
        return new Status(severity, CoreBundleActivator.getUniqueIdentifier(), message != null ? message : error.toString(), error);
    }

    public static final String unwrapErrorReport(String error) {
        if (error != null && error.startsWith("TCF error report")) {
            error = error.substring(error.indexOf("Error text:") + 11, error.indexOf("Error code:"));
            error = error.trim();
        }
        return error;
    }
}

