/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.search;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.processes.ui.search.NameValidator;
import org.eclipse.tcf.te.tcf.processes.ui.search.ProcessNodeGeneralMatcher;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.interfaces.ISearchMatcher;
import org.eclipse.tcf.te.ui.search.TreeViewerSearchDialog;
import org.eclipse.tcf.te.ui.utils.AbstractSearchable;

public class GeneralSearchable
extends AbstractSearchable {
    private static final String TARGET_NAME = "PM.TargetName";
    private static final String CASE_SENSITIVE = "PM.CaseSensitive";
    private Button fBtnCase;
    private BaseEditBrowseTextControl fSearchField;
    private String fTargetName;
    private boolean fCaseSensitive;

    public void createCommonPart(TreeViewerSearchDialog dialog, Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(Messages.GeneralSearchable_FindLabel);
        this.fSearchField = new BaseEditBrowseTextControl(null);
        this.fSearchField.setIsGroup(false);
        this.fSearchField.setHasHistory(false);
        this.fSearchField.setHideBrowseButton(true);
        this.fSearchField.setParentControlIsInnerPanel(true);
        this.fSearchField.setupPanel(composite);
        this.fSearchField.setEditFieldValidator((Validator)new NameValidator());
        Text text = (Text)this.fSearchField.getEditFieldControl();
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralSearchable.this.searchTextModified();
            }
        });
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralSearchable.this.optionChecked(e);
            }
        };
        Group group = new Group(parent, 0);
        group.setText(Messages.GeneralSearchable_GeneralOptions);
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(768));
        this.fBtnCase = new Button((Composite)group, 32);
        this.fBtnCase.setText(Messages.GeneralSearchable_CaseSensitive);
        GridData data = new GridData(768);
        this.fBtnCase.setLayoutData((Object)data);
        this.fBtnCase.addSelectionListener((SelectionListener)l);
        dialog.createSearchDirectionOptions((Composite)group);
    }

    protected void searchTextModified() {
        this.fireOptionChanged();
        this.fTargetName = this.fSearchField.getEditFieldControlText().trim();
    }

    protected void optionChecked(SelectionEvent e) {
        Object src = e.getSource();
        if (src == this.fBtnCase) {
            this.fCaseSensitive = this.fBtnCase.getSelection();
        }
    }

    public boolean isInputValid() {
        return this.fSearchField.isValid();
    }

    public void restoreValues(IDialogSettings settings) {
        if (settings != null) {
            this.fCaseSensitive = settings.getBoolean(CASE_SENSITIVE);
            this.fBtnCase.setSelection(this.fCaseSensitive);
            this.fTargetName = settings.get(TARGET_NAME);
            if (this.fTargetName != null) {
                this.fSearchField.setEditFieldControlText(this.fTargetName);
            }
        } else {
            this.fCaseSensitive = false;
            this.fTargetName = null;
        }
        this.fBtnCase.setSelection(this.fCaseSensitive);
        if (this.fTargetName != null) {
            this.fSearchField.setEditFieldControlText(this.fTargetName);
        }
    }

    public void persistValues(IDialogSettings settings) {
        if (settings != null) {
            settings.put(CASE_SENSITIVE, this.fCaseSensitive);
            settings.put(TARGET_NAME, this.fTargetName);
        }
    }

    public ISearchMatcher getMatcher() {
        return new ProcessNodeGeneralMatcher(this.fCaseSensitive, this.fTargetName);
    }

    public Point getPreferredSize() {
        return new Point(360, 130);
    }
}

