/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.layout;

import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectSetObjectAfter;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.xml.model.utils.ElementTarget;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

public final class VirtualLayoutDataCreationSupport
extends CreationSupport
implements IImplicitCreationSupport {
    private final ControlInfo m_control;
    private final Object m_dataObject;

    public VirtualLayoutDataCreationSupport(ControlInfo control, Object dataObject) {
        this.m_control = control;
        this.m_dataObject = dataObject;
    }

    public String toString() {
        return "virtual-LayoutData: " + this.m_object.getDescription().getComponentClass().getName();
    }

    public void setObject(XmlObjectInfo object) throws Exception {
        super.setObject(object);
        this.m_object.setObject(this.m_dataObject);
        this.m_control.addBroadcastListener(new XmlObjectSetObjectAfter(){

            public void invoke(XmlObjectInfo target, Object object) throws Exception {
                if (VirtualLayoutDataCreationSupport.this.m_object.getCreationSupport() != VirtualLayoutDataCreationSupport.this) {
                    VirtualLayoutDataCreationSupport.this.m_control.removeBroadcastListener(this);
                    return;
                }
                if (target == VirtualLayoutDataCreationSupport.this.m_control) {
                    VirtualLayoutDataCreationSupport.this.m_object.setObject(VirtualLayoutDataCreationSupport.this.m_dataObject);
                }
            }
        });
    }

    public String getTitle() {
        return this.toString();
    }

    public DocumentElement getElement() {
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                VirtualLayoutDataCreationSupport.this.materialize();
            }
        });
        return this.m_object.getCreationSupport().getElement();
    }

    private void materialize() throws Exception {
        ElementCreationSupport elementCreationSupport = new ElementCreationSupport();
        this.m_object.setCreationSupport((CreationSupport)elementCreationSupport);
        DocumentElement controlElement = this.m_control.getCreationSupport().getElement();
        Association association = Associations.property((String)"layoutData");
        association.add(this.m_object, new ElementTarget(controlElement, 0));
    }
}

