/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model.project;

import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.XtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.RuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.SubProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.WebProjectConfig;

@Accessors
public class XtextProjectConfig
implements IXtextProjectConfig {
    private RuntimeProjectConfig runtime = new RuntimeProjectConfig();
    private BundleProjectConfig runtimeTest = new BundleProjectConfig();
    private BundleProjectConfig genericIde = new BundleProjectConfig();
    private BundleProjectConfig eclipsePlugin = new BundleProjectConfig();
    private BundleProjectConfig eclipsePluginTest = new BundleProjectConfig();
    private WebProjectConfig web = new WebProjectConfig();
    @Inject
    private CodeConfig codeConfig;

    public void checkConfiguration(Issues issues) {
        Consumer<SubProjectConfig> _function = it -> it.checkConfiguration(issues);
        this.getEnabledProjects().forEach(_function);
    }

    public List<? extends SubProjectConfig> getAllProjects() {
        ArrayList _xblockexpression = null;
        ArrayList allProjects = CollectionLiterals.newArrayList();
        Iterables.addAll((Collection)allProjects, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new SubProjectConfig[]{this.runtime, this.runtimeTest, this.genericIde, this.eclipsePlugin, this.eclipsePluginTest, this.web})));
        _xblockexpression = allProjects;
        return _xblockexpression;
    }

    public List<? extends SubProjectConfig> getTestProjects() {
        ArrayList _xblockexpression = null;
        ArrayList testProjects = CollectionLiterals.newArrayList();
        Iterables.addAll((Collection)testProjects, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new BundleProjectConfig[]{this.runtimeTest, this.eclipsePluginTest})));
        _xblockexpression = testProjects;
        return _xblockexpression;
    }

    public List<? extends SubProjectConfig> getEnabledProjects() {
        ArrayList _xblockexpression = null;
        ArrayList enabledProjects = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> it.isEnabled();
        Iterable _filter = IterableExtensions.filter(this.getAllProjects(), (Functions.Function1)_function);
        Iterables.addAll((Collection)enabledProjects, (Iterable)_filter);
        _xblockexpression = enabledProjects;
        return _xblockexpression;
    }

    @Override
    public void initialize(Injector injector) {
        this.setDefaults();
        injector.injectMembers((Object)this);
        Consumer<SubProjectConfig> _function = it -> it.initialize(injector);
        this.getEnabledProjects().forEach(_function);
    }

    public void setDefaults() {
        this.runtime.setEnabled(true);
        Functions.Function1 _function = it -> it.isEnabled();
        boolean _exists = IterableExtensions.exists(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new SubProjectConfig[]{this.eclipsePlugin, this.web})), (Functions.Function1)_function);
        if (_exists) {
            this.genericIde.setEnabled(true);
        }
    }

    protected ManifestAccess newManifestAccess() {
        ManifestAccess _manifestAccess = new ManifestAccess();
        Procedures.Procedure1 _function = it -> it.setLineDelimiter(this.codeConfig.getLineDelimiter());
        return (ManifestAccess)ObjectExtensions.operator_doubleArrow((Object)_manifestAccess, (Procedures.Procedure1)_function);
    }

    protected PluginXmlAccess newPluginXmlAccess() {
        return new PluginXmlAccess();
    }

    protected XtextGeneratorFileSystemAccess newFileSystemAccess(String path, boolean overWrite) {
        return new XtextGeneratorFileSystemAccess(path, overWrite);
    }

    @Override
    @Pure
    public RuntimeProjectConfig getRuntime() {
        return this.runtime;
    }

    public void setRuntime(RuntimeProjectConfig runtime) {
        this.runtime = runtime;
    }

    @Override
    @Pure
    public BundleProjectConfig getRuntimeTest() {
        return this.runtimeTest;
    }

    public void setRuntimeTest(BundleProjectConfig runtimeTest) {
        this.runtimeTest = runtimeTest;
    }

    @Override
    @Pure
    public BundleProjectConfig getGenericIde() {
        return this.genericIde;
    }

    public void setGenericIde(BundleProjectConfig genericIde) {
        this.genericIde = genericIde;
    }

    @Override
    @Pure
    public BundleProjectConfig getEclipsePlugin() {
        return this.eclipsePlugin;
    }

    public void setEclipsePlugin(BundleProjectConfig eclipsePlugin) {
        this.eclipsePlugin = eclipsePlugin;
    }

    @Override
    @Pure
    public BundleProjectConfig getEclipsePluginTest() {
        return this.eclipsePluginTest;
    }

    public void setEclipsePluginTest(BundleProjectConfig eclipsePluginTest) {
        this.eclipsePluginTest = eclipsePluginTest;
    }

    @Override
    @Pure
    public WebProjectConfig getWeb() {
        return this.web;
    }

    public void setWeb(WebProjectConfig web) {
        this.web = web;
    }

    @Pure
    public CodeConfig getCodeConfig() {
        return this.codeConfig;
    }

    public void setCodeConfig(CodeConfig codeConfig) {
        this.codeConfig = codeConfig;
    }
}

