/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions.editpart;

import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.actions.editpart.AbstractAction;
import org.eclipse.bpel.ui.commands.SetVariableCommand;
import org.eclipse.bpel.ui.dialogs.VariableSelectorDialog;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class SetVariableAction
extends AbstractAction {
    public static final int REQUEST = 1;
    public static final int RESPONSE = 2;
    protected int type;

    public SetVariableAction(EditPart editPart, int type) {
        super(editPart);
        this.type = type;
    }

    public Image getIconImg() {
        if (this.type == 2) {
            return BPELUIPlugin.INSTANCE.getImage("obj16/outgoingvariable.gif");
        }
        return BPELUIPlugin.INSTANCE.getImage("obj16/incomingvariable.gif");
    }

    @Override
    public ImageDescriptor getIcon() {
        if (this.type == 2) {
            return BPELUIPlugin.INSTANCE.getImageDescriptor("obj16/outgoingvariable.gif");
        }
        return BPELUIPlugin.INSTANCE.getImageDescriptor("obj16/incomingvariable.gif");
    }

    @Override
    public boolean onButtonPressed() {
        Shell shell = this.viewer.getControl().getShell();
        EObject model = (EObject)this.editPart.getModel();
        VariableSelectorDialog dialog = new VariableSelectorDialog(shell, model, ModelHelper.getVariableType(model, this.getDirection()));
        dialog.setTitle(this.getDialogTitle());
        if (dialog.open() == 0) {
            Variable variable = dialog.getVariable();
            SetVariableCommand command = new SetVariableCommand(model, variable, this.getDirection());
            this.viewer.getEditDomain().getCommandStack().execute((Command)command);
        }
        return true;
    }

    protected int getDirection() {
        if (this.modelObject instanceof Invoke) {
            return this.type == 2 ? 1 : 0;
        }
        return this.type == 2 ? 0 : 1;
    }

    protected String getDialogTitle() {
        if (this.type == 2) {
            return Messages.SetVariableAction_Select_Response_Variable_2;
        }
        return Messages.SetVariableAction_Select_Request_Variable_2;
    }

    @Override
    public String getToolTip() {
        if (this.type == 2) {
            return Messages.SetResponseVarAction_Set_Response_Variable_1;
        }
        return Messages.SetRequestVarAction_Set_Request_Variable_1;
    }

    @Override
    public ImageDescriptor getDisabledIcon() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

