/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.debugsources;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DebugSourcesTreeElement {
    private final Set<DebugSourcesTreeElement> children = new LinkedHashSet<DebugSourcesTreeElement>();
    private final String name;
    private final String fullPath;
    private DebugSourcesTreeElement parent;
    private FileExist exists;

    public DebugSourcesTreeElement(String name, FileExist exists) {
        this.name = name;
        this.fullPath = null;
        this.exists = exists;
    }

    private DebugSourcesTreeElement(String name, String fullPath, FileExist exist) {
        this.name = name;
        this.fullPath = fullPath;
        this.exists = exist;
    }

    public DebugSourcesTreeElement addNode(String name, FileExist exists) {
        for (DebugSourcesTreeElement child : this.children) {
            if (!child.name.equals(name)) continue;
            if (exists == FileExist.YES) {
                child.exists = FileExist.YES;
            }
            return child;
        }
        return this.addChild(new DebugSourcesTreeElement(name, exists));
    }

    public DebugSourcesTreeElement addLeaf(String name, String fullPath, FileExist exists) {
        for (DebugSourcesTreeElement child : this.children) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        return this.addChild(new DebugSourcesTreeElement(name, fullPath, exists));
    }

    private DebugSourcesTreeElement addChild(DebugSourcesTreeElement child) {
        this.children.add(child);
        return child;
    }

    public Set<DebugSourcesTreeElement> getChildren() {
        return this.children;
    }

    public Set<DebugSourcesTreeElement> getChildren(boolean filesThatMayExistOnly) {
        if (filesThatMayExistOnly) {
            return this.children.stream().filter(c -> c.getExists() != FileExist.NO).collect(Collectors.toSet());
        }
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public String getName() {
        return this.name;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public FileExist getExists() {
        return this.exists;
    }

    public DebugSourcesTreeElement getParent() {
        return this.parent;
    }

    public void setParent(DebugSourcesTreeElement parent) {
        this.parent = parent;
    }

    public void setExist(FileExist exists) {
        this.exists = exists;
    }

    public String toString() {
        return Objects.toString(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.exists == null ? 0 : this.exists.hashCode());
        result = 31 * result + (this.fullPath == null ? 0 : this.fullPath.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DebugSourcesTreeElement other = (DebugSourcesTreeElement)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.exists != other.exists) {
            return false;
        }
        if (this.fullPath == null ? other.fullPath != null : !this.fullPath.equals(other.fullPath)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public static enum FileExist {
        YES,
        NO,
        UNKNOWN;

    }
}

