/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractCLaunchDelegate2
extends LaunchConfigurationDelegate {
    private boolean workspaceBuildBeforeLaunch;
    private boolean buildFailed;
    private final boolean requireCProject;
    static final String CONFIGURATION_IDS = "org.eclipse.cdt.make.core.configurationIds";
    static final String CONTENTS = "org.eclipse.cdt.make.core.contents";
    static final String CONTENTS_CONFIGURATION_IDS = "org.eclipse.cdt.make.core.configurationIds";
    private static final IStatus uiPromptStatus = new Status(4, "org.eclipse.debug.ui", 200, "", null);
    private static final IStatus promptStatusMainProj = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 1002, "", null);
    private static final IStatus promptStatusReferencedProjs = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 1003, "", null);

    public AbstractCLaunchDelegate2() {
        this.requireCProject = true;
    }

    public AbstractCLaunchDelegate2(boolean requireCProject) {
        this.requireCProject = requireCProject;
    }

    private HashSet<IProject> getReferencedProjectSet(IProject proj, HashSet<IProject> referencedProjSet) throws CoreException {
        IProject[] projects;
        referencedProjSet.add(proj);
        IProject[] iProjectArray = projects = proj.getReferencedProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            if (refProject.exists() && !referencedProjSet.contains(refProject)) {
                this.getReferencedProjectSet(refProject, referencedProjSet);
            }
            ++n2;
        }
        return referencedProjSet;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject[] orderedProjects = null;
        ArrayList<IProject> orderedProjList = null;
        ICProject cProject = this.verifyCProject(configuration);
        if (cProject != null) {
            HashSet<IProject> projectSet = this.getReferencedProjectSet(cProject.getProject(), new HashSet<IProject>());
            String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
            if (orderedNames != null) {
                ArrayList<IProject> unorderedProjects = new ArrayList<IProject>(projectSet.size());
                unorderedProjects.addAll(projectSet);
                orderedProjList = new ArrayList<IProject>(projectSet.size());
                String[] stringArray = orderedNames;
                int n = orderedNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String projectName = stringArray[n2];
                    for (IProject proj : unorderedProjects) {
                        if (!proj.getName().equals(projectName)) continue;
                        orderedProjList.add(proj);
                        unorderedProjects.remove(proj);
                        break;
                    }
                    ++n2;
                }
                orderedProjList.addAll(unorderedProjects);
                orderedProjects = orderedProjList.toArray(new IProject[orderedProjList.size()]);
            } else {
                IProject[] projects = projectSet.toArray(new IProject[projectSet.size()]);
                orderedProjects = ResourcesPlugin.getWorkspace().computeProjectOrder((IProject[])projects).projects;
            }
        }
        return orderedProjects;
    }

    protected boolean existsProblems(IProject proj) throws CoreException {
        IMarker[] markers = proj.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers.length > 0) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Integer severity = (Integer)marker.getAttribute("severity");
                if (severity != null && severity >= 2) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        Status status;
        if (exception != null) {
            MultiStatus multiStatus = new MultiStatus(this.getPluginID(), code, message, exception);
            multiStatus.add((IStatus)new Status(4, this.getPluginID(), code, exception.getLocalizedMessage(), exception));
            status = multiStatus;
        } else {
            status = new Status(4, this.getPluginID(), code, message, null);
        }
        throw new CoreException((IStatus)status);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)1);
            this.workspaceBuildBeforeLaunch = true;
            IProject project = null;
            ICProject cProject = CDebugUtils.getCProject((ILaunchConfiguration)configuration);
            if (cProject != null) {
                project = cProject.getProject();
            }
            if (project == null) {
                return false;
            }
            int buildBeforeLaunchValue = configuration.getAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 2);
            if (buildBeforeLaunchValue == 0) {
                return false;
            }
            String buildConfigID = null;
            if (configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", false)) {
                String programPath = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                programPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programPath);
                ICConfigurationDescription buildConfig = LaunchUtils.getBuildConfigByProgramPath(project, programPath);
                if (buildConfig != null) {
                    buildConfigID = buildConfig.getId();
                }
            }
            if (buildConfigID == null && (buildConfigID = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "")).length() == 0) {
                buildConfigID = null;
            }
            if (buildConfigID != null) {
                boolean idIsGood = false;
                ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(project, false);
                if (desc != null) {
                    boolean bl = idIsGood = desc.getConfigurationById(buildConfigID) != null;
                }
                if (!idIsGood) {
                    buildConfigID = null;
                }
            }
            this.buildProject(project, buildConfigID, (IProgressMonitor)submon.newChild(1));
            return false;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void buildProject(final IProject project, final String buildConfigID, IProgressMonitor monitor) throws CoreException {
        int TOTAL_TICKS = 1000;
        this.buildFailed = false;
        IWorkspaceRunnable build = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)pm, (String)"", (int)1000);
                try {
                    int buildCount;
                    int n = buildCount = buildConfigID == null ? 1 : project.getDescription().getBuildSpec().length;
                    if (buildCount == 0) {
                        return;
                    }
                    int subtaskTicks = 1000 / buildCount;
                    if (buildConfigID != null) {
                        Map<String, String> cfgIdArgs = AbstractCLaunchDelegate2.cfgIdsToMap(new String[]{buildConfigID}, new HashMap<String, String>());
                        cfgIdArgs.put(AbstractCLaunchDelegate2.CONTENTS, "org.eclipse.cdt.make.core.configurationIds");
                        ICommand[] commands = project.getDescription().getBuildSpec();
                        if (!$assertionsDisabled && buildCount != commands.length) {
                            throw new AssertionError();
                        }
                        ICommand[] iCommandArray = commands;
                        int n2 = commands.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            ICommand command = iCommandArray[n3];
                            HashMap<String, String> args = command.getArguments();
                            if (args == null) {
                                args = new HashMap<String, String>(cfgIdArgs);
                            } else {
                                args.putAll(cfgIdArgs);
                            }
                            if (localmonitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            project.build(10, command.getBuilderName(), args, (IProgressMonitor)localmonitor.newChild(subtaskTicks));
                            ++n3;
                        }
                    } else {
                        project.build(10, (IProgressMonitor)localmonitor.newChild(subtaskTicks));
                    }
                }
                finally {
                    if (pm != null) {
                        pm.done();
                    }
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(build, (IProgressMonitor)new LaunchUtils.BuildProgressMonitor(monitor, 1000));
        }
        catch (Exception e) {
            this.buildFailed = true;
        }
    }

    private static Map<String, String> cfgIdsToMap(String[] ids, Map<String, String> map) {
        map.put("org.eclipse.cdt.make.core.configurationIds", AbstractCLaunchDelegate2.encodeList(Arrays.asList(ids)));
        return map;
    }

    private static String encodeList(List<String> values) {
        StringBuilder str = new StringBuilder();
        for (String entry : values) {
            str.append(AbstractCLaunchDelegate2.escapeChars(entry, "|\\", '\\'));
            str.append("|");
        }
        return str.toString();
    }

    private static String escapeChars(String string, String escapeChars, char escapeChar) {
        StringBuilder str = new StringBuilder(string);
        int i = 0;
        while (i < str.length()) {
            if (escapeChars.indexOf(str.charAt(i)) != -1) {
                str.insert(i, escapeChar);
                ++i;
            }
            ++i;
        }
        return str.toString();
    }

    private Object[] createPrompterArgs(ILaunchConfiguration launchConfig) throws CoreException {
        ICProjectDescription desc;
        IProject project = CDebugUtils.getCProject((ILaunchConfiguration)launchConfig).getProject();
        Object[] args = new Object[]{launchConfig, project.getName(), ""};
        String buildConfigId = launchConfig.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
        if (buildConfigId.length() > 0 && (desc = CCorePlugin.getDefault().getProjectDescription(project, false)) != null) {
            ICConfigurationDescription cfgDescActive = desc.getActiveConfiguration();
            ICConfigurationDescription cfgDesc = desc.getConfigurationById(buildConfigId);
            if (cfgDesc != null && cfgDesc != cfgDescActive) {
                args[2] = cfgDesc.getName();
            }
        }
        return args;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)LaunchMessages.AbstractCLaunchDelegate_BuildBeforeLaunch, (int)10);
            if (!this.workspaceBuildBeforeLaunch && 1 == configuration.getAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 2)) {
                localMonitor.subTask(LaunchMessages.AbstractCLaunchDelegate_PerformingBuild);
                if (this.buildForLaunch(configuration, mode, (IProgressMonitor)localMonitor.newChild(7))) {
                    localMonitor.subTask(LaunchMessages.AbstractCLaunchDelegate_PerformingIncrementalBuild);
                    ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)localMonitor.newChild(3));
                }
            }
            boolean continueLaunch = true;
            ICProject cproject = CDebugUtils.getCProject((ILaunchConfiguration)configuration);
            if (cproject != null) {
                IProject project = cproject.getProject();
                localMonitor.subTask(DebugCoreMessages.LaunchConfigurationDelegate_6);
                if (this.buildFailed || this.existsProblems(project)) {
                    IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(uiPromptStatus);
                    if (prompter != null) {
                        continueLaunch = (Boolean)prompter.handleStatus(promptStatusMainProj, (Object)this.createPrompterArgs(configuration));
                    } else assert (false);
                } else {
                    IProject[] projects;
                    IProject[] iProjectArray = projects = this.getBuildOrder(configuration, mode);
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject proj = iProjectArray[n2];
                        if (!proj.equals((Object)project) && this.existsProblems(proj)) {
                            IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(uiPromptStatus);
                            prompter = DebugPlugin.getDefault().getStatusHandler(uiPromptStatus);
                            if (prompter != null) {
                                continueLaunch = (Boolean)prompter.handleStatus(promptStatusReferencedProjs, (Object)this.createPrompterArgs(configuration));
                                break;
                            }
                            assert (false);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            boolean bl = continueLaunch;
            return bl;
        }
        finally {
            this.workspaceBuildBeforeLaunch = false;
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected ICProject verifyCProject(ILaunchConfiguration config) throws CoreException {
        ICProject cproject;
        String name = CDebugUtils.getProjectName((ILaunchConfiguration)config);
        if (name == null && this.requireCProject) {
            this.abort(LaunchMessages.AbstractCLaunchDelegate_C_Project_not_specified, null, 102);
        }
        if ((cproject = CDebugUtils.getCProject((ILaunchConfiguration)config)) == null && this.requireCProject) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!proj.exists()) {
                this.abort(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_Project_NAME_does_not_exist, (Object)name), null, 103);
            } else if (!proj.isOpen()) {
                this.abort(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_Project_NAME_is_closed, (Object)name), null, 103);
            }
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Not_a_C_CPP_project, null, 103);
        }
        return cproject;
    }

    protected IPath getWorkingDirectoryPath(ILaunchConfiguration config) throws CoreException {
        String expandedLocation;
        String location = config.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        if (location != null && !(expandedLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(location)).isEmpty()) {
            return new Path(expandedLocation);
        }
        return null;
    }

    protected File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            ICProject cp = CDebugUtils.getCProject((ILaunchConfiguration)configuration);
            if (cp == null) {
                return null;
            }
            IProject p = cp.getProject();
            return p.getLocation().toFile();
        }
        if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
        }
        this.abort(LaunchMessages.AbstractCLaunchDelegate_Working_directory_does_not_exist, new FileNotFoundException(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_WORKINGDIRECTORY_PATH_not_found, (Object)path.toOSString())), 101);
        return null;
    }

    protected IPath verifyProgramPath(ILaunchConfiguration configuration, ICProject cproject) throws CoreException {
        Path programPath;
        String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        if (programName == null) {
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Program_file_not_specified, null, 105);
        }
        if ((programPath = new Path(programName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programName))).isEmpty()) {
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Program_file_does_not_exist, null, 104);
        }
        if (!programPath.isAbsolute() && cproject != null) {
            IFile wsProgramPath = cproject.getProject().getFile((IPath)programPath);
            programPath = wsProgramPath.getLocation();
        }
        if (!programPath.toFile().exists()) {
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Program_file_does_not_exist, new FileNotFoundException(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_PROGRAM_PATH_not_found, (Object)programPath.toOSString())), 104);
        }
        return programPath;
    }

    protected abstract String getPluginID();
}

