/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.internal.core.util.ElementTypeDescriber;

public class ScriptModelUtil {
    public static final IModelElement[] NO_ELEMENTS = new IModelElement[0];
    private static ElementTypeDescriber elementTypeDescriber = null;

    public static void reconcile(ISourceModule unit) throws ModelException {
        unit.reconcile(false, null, null);
    }

    public static boolean isPrimary(ISourceModule unit) {
        return unit.getOwner() == null;
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (CharOperation.pathMatch(pattern, path, true, '/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IProjectFragment getProjectFragment(IModelElement element) {
        return (IProjectFragment)element.getAncestor(3);
    }

    public static IModelElement findInSourceModule(ISourceModule cu, IModelElement element) {
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Implement find in source module...");
        }
        return null;
    }

    public static void searchTypeDeclarations(IScriptProject project, String patternString, TypeNameMatchRequestor requestor) {
        block2: {
            IDLTKSearchScope scope = SearchEngine.createSearchScope(project);
            try {
                SearchEngine engine = new SearchEngine();
                engine.searchAllTypeNames(null, 0, patternString.toCharArray(), 2, 0, scope, requestor, 3, null);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public static void searchMethodDeclarations(IScriptProject project, String patternString, SearchRequestor requestor) {
        block2: {
            IDLTKSearchScope scope = SearchEngine.createSearchScope(project);
            try {
                SearchEngine engine = new SearchEngine();
                SearchPattern pattern = SearchPattern.createPattern(patternString, 1, 0, 2, DLTKLanguageManager.getLanguageToolkit(project));
                engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public static IModelElement findType(IModelElement module, String qualifiedName, String delimeter) {
        if (module instanceof IType) {
            IType type = (IType)module;
            String tmpFqn = type.getTypeQualifiedName(delimeter);
            if (!tmpFqn.startsWith(delimeter)) {
                tmpFqn = String.valueOf(delimeter) + tmpFqn;
            }
            if (tmpFqn.equals(qualifiedName)) {
                return type;
            }
        }
        if (module instanceof IParent) {
            IModelElement el = null;
            IParent p = (IParent)((Object)module);
            try {
                IModelElement[] childs = p.getChildren();
                int i = 0;
                while (i < childs.length) {
                    el = ScriptModelUtil.findType(childs[i], qualifiedName, delimeter);
                    if (el != null) {
                        return el;
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isExceptionToBeLogged(CoreException exception) {
        if (!(exception instanceof ModelException)) {
            return true;
        }
        ModelException je = (ModelException)exception;
        if (!je.isDoesNotExist()) {
            return true;
        }
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: ModelUtil: isExceptionToBeLogged. Require addition of ModelStatus.getgetElements method...");
        }
        return true;
    }

    public static String getFullyQualifiedName(IType type) {
        return type.getFullyQualifiedName();
    }

    public static String getRenamedCUName(ISourceModule cu, String newMainName) {
        int i;
        String oldName = cu.getPath().lastSegment();
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit(cu);
        String[] languageFileExtensions = ScriptModelUtil.getFileExtensions(languageToolkit);
        if (languageFileExtensions != null) {
            i = 0;
            while (i < languageFileExtensions.length) {
                if (newMainName.endsWith(languageFileExtensions[i])) {
                    return newMainName;
                }
                ++i;
            }
        }
        if ((i = oldName.lastIndexOf(46)) != -1) {
            return String.valueOf(newMainName) + oldName.substring(i);
        }
        return newMainName;
    }

    public static String[] getFileExtensions(IDLTKLanguageToolkit languageToolkit) {
        IContentType type = Platform.getContentTypeManager().getContentType(languageToolkit.getLanguageContentType());
        if (type != null) {
            return type.getFileSpecs(8);
        }
        return null;
    }

    public static boolean isSuperType(ITypeHierarchy hierarchy, IType possibleSuperType, IType type) {
        IType[] superClass = hierarchy.getSuperclass(type);
        if (superClass != null) {
            int q = 0;
            while (q < superClass.length) {
                if (possibleSuperType.equals(superClass[q]) || ScriptModelUtil.isSuperType(hierarchy, possibleSuperType, superClass[q])) {
                    return true;
                }
                ++q;
            }
        }
        return false;
    }

    public static IPath toPath(String[] pkgName) {
        if (pkgName.length == 0) {
            return Path.EMPTY;
        }
        Path path = new Path(pkgName[0]);
        int i = 1;
        while (i < pkgName.length) {
            path = path.append(pkgName[i]);
            ++i;
        }
        return path;
    }

    public static String describeElementType(int elementType) {
        if (elementTypeDescriber == null) {
            elementTypeDescriber = new ElementTypeDescriber();
        }
        return elementTypeDescriber.describe(elementType);
    }
}

