/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.eclipse.resources.mgt.operation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.eclipse.resources.mgt.util.EclipseModelsAccessor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFeatureOperation
extends WorkspaceModifyOperation {
    protected IProject _project;
    protected String _ID;
    protected String _label;
    protected String _provider;
    protected String _version;
    protected List<String> _pluginList;
    protected List<String> _includedFeaturesList;
    protected String _descriptionFileUri;
    protected String _descriptionUrl;
    protected String _copyrightFileUri;
    protected String _copyrightUrl;
    protected String _licenseFileUri;
    protected String _licenseUrl;

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Assert.isNotNull((Object)this._ID, (String)"Feature ID can't be null");
        Assert.isLegal((this._ID == null || this._ID.length() != 0 ? 1 : 0) != 0, (String)"Feature ID can't be empty");
        this._project = this.createFeature(monitor);
    }

    protected IProject createFeature(IProgressMonitor monitor) throws CoreException {
        IProject afFeature = ResourcesPlugin.getWorkspace().getRoot().getProject(this._ID);
        afFeature.refreshLocal(2, monitor);
        if (!afFeature.exists()) {
            afFeature.create(monitor);
            afFeature.open(monitor);
            IProjectDescription projectDescription = afFeature.getWorkspace().newProjectDescription(afFeature.getName());
            String[] newIds = new String[]{"org.eclipse.pde.FeatureNature"};
            projectDescription.setNatureIds(newIds);
            afFeature.setDescription(projectDescription, monitor);
            this.createBuildPropertiesFile(afFeature);
            this.createFeaturePropertiesFile(afFeature);
            this.createFeatureXMLFile(afFeature);
            afFeature.refreshLocal(1, monitor);
        }
        return afFeature;
    }

    protected void createBuildPropertiesFile(IProject iProject) throws CoreException {
        IFile buildProperties = iProject.getFile("build.properties");
        StringBuffer contents = new StringBuffer();
        contents.append("bin.includes = feature.xml,\\").append("\n");
        contents.append("               ").append("feature.properties\n");
        buildProperties.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), false, null);
    }

    protected void createFeaturePropertiesFile(IProject iProject) throws CoreException {
        IFile buildProperties = iProject.getFile("feature.properties");
        StringBuffer contents = new StringBuffer();
        contents.append("");
        contents.append("#" + this._ID + " prorpeties \n");
        contents.append("# Name of the feature \n");
        contents.append("featureName=");
        contents.append("# Name of the company that provides the feature \n");
        contents.append("providerName=").append(this.getFeatureProvider()).append("\n\n");
        contents.append("# URL of the \"Feature Description\"\n");
        contents.append("descriptionURL=").append(this.getDescriptionUrl()).append("\n\n");
        contents.append("# Description of the feature \n");
        contents.append("description=").append(this.getDescription()).append("\n\n");
        contents.append("# URL of the \"Feature License\"\n");
        contents.append("licenseURL=").append(this.getLicenseUrl()).append("\n\n");
        contents.append("# License of the feature \n");
        contents.append("license=").append(this.getLicense()).append("\n\n");
        contents.append("# URL of the \"Feature Copyright\"\n");
        contents.append("copyrightURL=").append(this.getCopyrightUrl()).append("\n\n");
        contents.append("# Copyright of the feature \n");
        contents.append("copyright=").append(this.getCopyright()).append("\n\n");
        buildProperties.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), false, null);
    }

    protected void createFeatureXMLFile(IProject iProject) throws CoreException {
        StringBuffer contents = this.createFeatureXMLContent();
        Assert.isNotNull((Object)contents, (String)"A problem is occured when creating feature xml file content");
        IFile featureXml = iProject.getFile("feature.xml");
        featureXml.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), false, null);
    }

    protected StringBuffer createFeatureXMLContent() {
        StringBuffer pluginIncludeContent;
        StringBuffer contents = new StringBuffer();
        contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        contents.append("<feature\n");
        contents.append("\tid=\"" + this.getFeatureID() + "\"\n");
        contents.append("\tversion=\"" + this.getFeatureVersion() + "\"\n");
        contents.append("\tlabel=\"%featureName\"\n");
        contents.append("\tprovider-name=\"%providerName\">\n");
        contents.append("\t<description url=\"%descriptionURL\">\n");
        contents.append("\t\t%description\n");
        contents.append("\t</description>\n");
        contents.append("\t<copyright url=\"%copyrightURL\">\n");
        contents.append("\t\t%copyright\n");
        contents.append("\t</copyright>\n");
        contents.append("\t<license url=\"%licenseURL\">\n");
        contents.append("\t\t%license\n");
        contents.append("\t</license>\n");
        StringBuffer featureIncludeContent = this.createIncludeFeatureXMLContent();
        if (featureIncludeContent != null && featureIncludeContent.length() > 0) {
            contents.append(featureIncludeContent);
        }
        if ((pluginIncludeContent = this.createIncludePluginXMLContent()) != null && pluginIncludeContent.length() > 0) {
            contents.append(pluginIncludeContent);
        }
        contents.append("</feature>\n");
        return contents;
    }

    protected StringBuffer createIncludeFeatureXMLContent() {
        StringBuffer contents = new StringBuffer();
        ArrayList<String> includedFeatures = new ArrayList<String>();
        if (this._includedFeaturesList != null) {
            for (String featureID : this._includedFeaturesList) {
                if (includedFeatures.contains(featureID)) continue;
                String version = EclipseModelsAccessor.getFeatureVersion(featureID);
                contents.append("\t<includes\n");
                contents.append("\t\tid=\"" + featureID + "\"\n");
                contents.append("\t\tversion=\"" + version + "\"/> \n");
                includedFeatures.add(featureID);
            }
        }
        return contents;
    }

    protected StringBuffer createIncludePluginXMLContent() {
        StringBuffer contents = new StringBuffer();
        ArrayList<String> includedPlugins = new ArrayList<String>();
        if (this._pluginList != null) {
            for (String pluginID : this._pluginList) {
                if (includedPlugins.contains(pluginID)) continue;
                String version = EclipseModelsAccessor.getPluginVersion(pluginID);
                contents.append("\t<plugin\n");
                contents.append("\t\tid=\"" + pluginID + "\"\n");
                contents.append("\t\tdownload-size=\"0\" \n");
                contents.append("\t\tinstall-size=\"0\" \n");
                contents.append("\t\tversion=\"" + version + "\" \n");
                contents.append("\t\tunpack=\"false\" /> \n");
                includedPlugins.add(pluginID);
            }
        }
        return contents;
    }

    public IProject getFeatureProject() {
        return this._project;
    }

    public String getFeatureID() {
        return this._ID;
    }

    public void setFeatureID(String featureID) {
        this._ID = featureID;
    }

    public String getFeatureLabel() {
        return this._label;
    }

    public void setFeatureLabel(String featureLabel) {
        this._label = featureLabel;
    }

    public String getFeatureProvider() {
        return this._provider;
    }

    public void setFeatureProvider(String featureProvider) {
        this._provider = featureProvider;
    }

    public String getFeatureVersion() {
        if (this._version != null && this._version.length() > 0) {
            return this._version;
        }
        return "0.1.0";
    }

    public void setFeatureVersion(String featureVersion) {
        this._version = featureVersion;
    }

    public List<String> getPluginList() {
        return this._pluginList;
    }

    public void setPluginList(List<String> pluginList) {
        this._pluginList = pluginList;
    }

    public List<String> getIncludedFeaturesList() {
        return this._includedFeaturesList;
    }

    public void setIncludedFeaturesList(List<String> includedFeaturesList) {
        this._includedFeaturesList = includedFeaturesList;
    }

    public String getDescriptionFileUri() {
        return this._descriptionFileUri;
    }

    public String getDescription() {
        if (this._descriptionFileUri != null && this._descriptionFileUri.length() > 0) {
            String descriptionFileContent = "";
            return descriptionFileContent;
        }
        return "[Enter Feature Description here.]";
    }

    public void setDescriptionFileUri(String descriptionFileUri) {
        this._descriptionFileUri = descriptionFileUri;
    }

    public String getDescriptionUrl() {
        if (this._descriptionUrl != null && this._descriptionUrl.length() > 0) {
            return this._descriptionUrl;
        }
        return "http://www.example.com/description";
    }

    public void setDescriptionUrl(String descriptionUrl) {
        this._descriptionUrl = descriptionUrl;
    }

    public String getCopyrightFileUri() {
        return this._copyrightFileUri;
    }

    public String getCopyright() {
        if (this._copyrightFileUri != null && this._copyrightFileUri.length() > 0) {
            String copyrightFileContent = "";
            return copyrightFileContent;
        }
        return "[Enter Copyright Description here.]";
    }

    public void setCopyrightFileUri(String copyrightFileUri) {
        this._copyrightFileUri = copyrightFileUri;
    }

    public String getCopyrightUrl() {
        if (this._copyrightUrl != null && this._copyrightUrl.length() > 0) {
            return this._copyrightUrl;
        }
        return "http://www.example.com/copyright";
    }

    public void setCopyrightUrl(String copyrightUrl) {
        this._copyrightUrl = copyrightUrl;
    }

    public String getLicenseFileUri() {
        return this._licenseFileUri;
    }

    public void setLicenseFileUri(String licenseFileUri) {
        this._licenseFileUri = licenseFileUri;
    }

    public String getLicense() {
        if (this._licenseFileUri != null && this._licenseFileUri.length() > 0) {
            String licenseFileContent = "";
            return licenseFileContent;
        }
        return "[Enter License Description here.]";
    }

    public String getLicenseUrl() {
        if (this._licenseUrl != null && this._licenseUrl.length() > 0) {
            return this._licenseUrl;
        }
        return "http://www.example.com/license";
    }

    public void setLicenseUrl(String licenseUrl) {
        this._licenseUrl = licenseUrl;
    }
}

