/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.filters;

import static org.eclipse.epp.logging.aeri.core.Constants.SYSPROP_ECLIPSE_PRODUCT;

import java.util.List;
import java.util.regex.Pattern;

import org.eclipse.core.runtime.IStatus;

import com.google.common.base.Predicate;

public class AcceptedProductsFilter implements Predicate<IStatus> {

    private List<Pattern> patterns;

    public AcceptedProductsFilter(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public boolean apply(IStatus input) {
        String product = System.getProperty(SYSPROP_ECLIPSE_PRODUCT);
        return product == null ? false : isAccepted(product);
    }

    private boolean isAccepted(String product) {
        for (Pattern pattern : patterns) {
            if (pattern.matcher(product).matches()) {
                return true;
            }
        }
        return false;
    }
}
