/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class LongRunningAction
extends SafeAction {
    private static final ThreadLocal<Boolean> CANCELED = new ThreadLocal();
    private IWorkbenchPage page;

    public LongRunningAction(IWorkbenchPage page) {
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text, String toolTipText, ImageDescriptor image) {
        super(text, toolTipText, image);
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text, ImageDescriptor image) {
        super(text, image);
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text, String toolTipText) {
        super(text, toolTipText);
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text, int style) {
        super(text, style);
        this.page = page;
    }

    public LongRunningAction(IWorkbenchPage page, String text) {
        super(text);
        this.page = page;
    }

    public LongRunningAction() {
    }

    public LongRunningAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public LongRunningAction(String text, int style) {
        super(text, style);
    }

    public LongRunningAction(String text, String toolTipText, ImageDescriptor image) {
        super(text, toolTipText, image);
    }

    public LongRunningAction(String text, String toolTipText) {
        super(text, toolTipText);
    }

    public LongRunningAction(String text) {
        super(text);
    }

    public IWorkbenchPage getPage() {
        if (this.page != null) {
            return this.page;
        }
        IWorkbenchWindow window = UIUtil.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public void setPage(IWorkbenchPage page) {
        this.page = page;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        if (this.page != null) {
            return this.page.getWorkbenchWindow();
        }
        return UIUtil.getActiveWorkbenchWindow();
    }

    public Display getDisplay() {
        IWorkbenchWindow workbenchWindow = this.getWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow.getShell().getDisplay();
        }
        return PlatformUI.getWorkbench().getDisplay();
    }

    @Override
    public Shell getShell() {
        IWorkbenchWindow workbenchWindow = this.getWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow.getShell();
        }
        return UIUtil.getShell();
    }

    @Deprecated
    protected final int getTotalWork() {
        return -1;
    }

    @Deprecated
    protected final void setTotalWork(int totalWork) {
    }

    protected final void cancel() {
        CANCELED.set(Boolean.TRUE);
    }

    @Override
    protected final void safeRun() throws Exception {
        try {
            CANCELED.set(Boolean.FALSE);
            this.preRun();
            if (CANCELED.get() != Boolean.TRUE) {
                new Job(this.getText()){

                    protected IStatus run(IProgressMonitor progressMonitor) {
                        try {
                            LongRunningAction.this.doRun(progressMonitor);
                            return Status.OK_STATUS;
                        }
                        catch (Exception ex) {
                            return new Status(4, LongRunningAction.this.getBundleID(), ex.getMessage(), (Throwable)ex);
                        }
                    }
                }.schedule();
            }
        }
        finally {
            CANCELED.remove();
        }
    }

    protected void preRun() throws Exception {
    }

    protected String getBundleID() {
        return "org.eclipse.net4j.util.ui";
    }

    protected abstract void doRun(IProgressMonitor var1) throws Exception;

    protected final void checkCancelation(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

