/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.emf.readonly;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.emf.readonly.spi.IReadOnlyManagerProcessor;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.editor.IReloadableEditor;
import org.eclipse.papyrus.infra.ui.editor.reload.EditorReloadEvent;
import org.eclipse.papyrus.infra.ui.editor.reload.IEditorReloadListener;
import org.eclipse.papyrus.infra.ui.editor.reload.IReloadContextProvider;
import org.eclipse.papyrus.infra.ui.internal.emf.Activator;

public class EditorReloadProcessor
implements IReadOnlyManagerProcessor {
    public void processReadOnlyManager(ReadOnlyManager readOnlyManager, EditingDomain editingDomain) {
        try {
            IReloadableEditor reloadable;
            IMultiDiagramEditor editor = (IMultiDiagramEditor)ServiceUtilsForResourceSet.getInstance().getService(IMultiDiagramEditor.class, (Object)editingDomain.getResourceSet());
            if (editor != null && (reloadable = IReloadableEditor.Adapter.getAdapter((IMultiDiagramEditor)editor)) != null) {
                reloadable.addEditorReloadListener((IEditorReloadListener)new ReadOnlyEditorReloadListener(readOnlyManager));
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    private static class ReadOnlyEditorReloadListener
    implements IEditorReloadListener {
        private ReadOnlyManager readOnlyManager;

        ReadOnlyEditorReloadListener(ReadOnlyManager readOnlyManager) {
            this.readOnlyManager = readOnlyManager;
        }

        public void editorAboutToReload(EditorReloadEvent event) {
            HashMap reloadContexts = Maps.newHashMap();
            for (Iterable partition : this.readOnlyManager.getReadOnlyHandlers().values()) {
                for (IReadOnlyHandler2 next : partition) {
                    IReloadContextProvider provider;
                    if (reloadContexts.containsKey(next.getClass()) || (provider = (IReloadContextProvider)PlatformHelper.getAdapter((Object)next, IReloadContextProvider.class)) == null) continue;
                    reloadContexts.put(next.getClass(), provider.createReloadContext());
                }
            }
            if (!reloadContexts.isEmpty()) {
                event.putContext((Object)reloadContexts);
            }
        }

        public void editorReloaded(EditorReloadEvent event) {
            try {
                this.readOnlyManager = (ReadOnlyManager)ReadOnlyManager.getReadOnlyHandler((EditingDomain)((EditingDomain)event.getEditor().getServicesRegistry().getService(TransactionalEditingDomain.class)));
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
            Object context = event.getContext();
            if (context instanceof Map) {
                Map reloadContexts = (Map)context;
                for (Iterable partition : this.readOnlyManager.getReadOnlyHandlers().values()) {
                    for (IReadOnlyHandler2 next : partition) {
                        IReloadContextProvider provider;
                        Object reloadContext = reloadContexts.get(next.getClass());
                        if (reloadContext == null || (provider = (IReloadContextProvider)PlatformHelper.getAdapter((Object)next, IReloadContextProvider.class)) == null) continue;
                        provider.restore(reloadContext);
                    }
                }
            }
        }
    }
}

