/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleStringEditor;
import org.eclipse.papyrus.infra.widgets.selectors.BooleanSelector;
import org.eclipse.swt.widgets.Composite;

public class MultipleBooleanEditor
extends MultipleStringEditor<BooleanSelector> {
    private final String[] booleanProposals = new String[]{"true", "false"};

    public MultipleBooleanEditor(Composite parent, int style) {
        super(parent, style, new BooleanSelector());
    }

    public MultipleBooleanEditor(Composite parent, boolean directCreation, boolean directCreationWithTreeViewer, int style) {
        super(parent, style, new BooleanSelector(), directCreation, directCreationWithTreeViewer);
    }

    @Override
    protected CellEditor createCellEditor(Object element) {
        return new ComboBoxCellEditor((Composite)this.getViewer().getTree(), this.booleanProposals, 8);
    }

    @Override
    protected Object getEditingValue(Object object) {
        List<String> booleans = Arrays.asList(this.booleanProposals);
        if (object == null || object.equals("")) {
            return 0;
        }
        return booleans.indexOf(object.toString());
    }

    @Override
    protected Object getValueToSet(Object element, Object value) {
        Object newValue = value;
        if (element instanceof Boolean) {
            newValue = value.equals(0) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return newValue;
    }

    @Override
    protected Object getDefaultValue() {
        return true;
    }
}

