/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.profile.index;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.language.ILanguage;
import org.eclipse.papyrus.infra.core.language.ILanguageProvider;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.language.LanguageChangeEvent;
import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.profile.index.IProfileIndex;
import org.osgi.framework.Bundle;

public class ProfileLanguageProvider
implements ILanguageProvider,
IExecutableExtension {
    private static final Pattern NAME_PATTERN = Pattern.compile("(?:(profile)|language)\\.(\\d+)");
    private IConfigurationElement config;
    private Map<URI, String> languageClasses;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
        if (!(data instanceof Map)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.uml.tools", "Initialization parameter 'data' is not a Map in language provider from contributor " + config.getContributor().getName()));
        }
        Map map = (Map)data;
        HashMap profileURIs = Maps.newHashMap();
        HashMap languages = Maps.newHashMap();
        for (Map.Entry next : map.entrySet()) {
            Matcher m = NAME_PATTERN.matcher((CharSequence)next.getKey());
            if (!m.find()) {
                Activator.log.warn(String.format("Invalid profile language provider parameter name %s from contributor %s", next.getKey(), config.getContributor().getName()));
                continue;
            }
            if (m.group(1) != null) {
                profileURIs.put(m.group(2), URI.createURI((String)((String)next.getValue()), (boolean)true));
                continue;
            }
            languages.put(m.group(2), (String)next.getValue());
        }
        this.languageClasses = Maps.newHashMap();
        for (Map.Entry next : profileURIs.entrySet()) {
            String languageClass = (String)languages.remove(next.getKey());
            if (languageClass == null) {
                Activator.log.warn(String.format("Missing language class for profile %s from contributor %s", next.getValue(), config.getContributor().getName()));
                continue;
            }
            this.languageClasses.put((URI)next.getValue(), languageClass);
        }
        for (Map.Entry next : languages.values()) {
            Activator.log.warn(String.format("Missing profile URI for language class %s from contributor %s", next, config.getContributor().getName()));
        }
    }

    public Iterable<ILanguage> getLanguages(final ILanguageService languageService, final URI modelURI, final boolean uriHasFileExtension) {
        Set<ILanguage> result = Collections.emptySet();
        final URI uriToQuery = uriHasFileExtension ? modelURI : modelURI.appendFileExtension("uml");
        try {
            IProfileIndex index = null;
            ServicesRegistry registry = (ServicesRegistry)languageService.getAdapter(ServicesRegistry.class);
            if (registry != null) {
                try {
                    index = (IProfileIndex)registry.getService(IProfileIndex.class);
                }
                catch (BadStateException e) {
                    registry.startServicesByClassKeys(new Class[]{IProfileIndex.class});
                    index = (IProfileIndex)registry.getService(IProfileIndex.class);
                }
            }
            if (index != null) {
                ListenableFuture<Set<URI>> futureProfiles = index.getAppliedProfiles(uriToQuery);
                if (futureProfiles.isDone()) {
                    result = this.getLanguages((Set)Futures.getUnchecked(futureProfiles));
                    if (Activator.log.isTraceEnabled("providers/language")) {
                        Activator.log.trace("providers/language", String.format("Languages already indexed for %s: %s", uriToQuery, result));
                    }
                } else {
                    final Set<ILanguage> immediateLanguages = this.getLanguages(index.getIntrinsicAppliedProfiles(uriToQuery));
                    result = immediateLanguages;
                    if (!result.isEmpty() && Activator.log.isTraceEnabled("providers/language")) {
                        Activator.log.trace("providers/language", String.format("Partial result already available for %s: %s", uriToQuery, immediateLanguages));
                    }
                    Futures.addCallback(futureProfiles, (FutureCallback)new FutureCallback<Set<URI>>(){

                        public void onSuccess(Set<URI> result) {
                            Set languages = ProfileLanguageProvider.this.getLanguages(result);
                            languages.removeAll(immediateLanguages);
                            if (languages.isEmpty()) {
                                if (Activator.log.isTraceEnabled("providers/language")) {
                                    Activator.log.trace("providers/language", "No further languages available for " + uriToQuery);
                                }
                            } else {
                                if (Activator.log.isTraceEnabled("providers/language")) {
                                    Activator.log.trace("providers/language", String.format("Remaining languages now available for %s: %s", uriToQuery, languages));
                                }
                                LanguageChangeEvent event = new LanguageChangeEvent((Object)ProfileLanguageProvider.this, 1, modelURI, uriHasFileExtension, (Iterable)languages);
                                languageService.languagesChanged(event);
                            }
                        }

                        public void onFailure(Throwable t) {
                            Activator.log.error(String.format("Failed to access profile index for resource %s", uriToQuery), t);
                        }
                    }, (Executor)MoreExecutors.directExecutor());
                }
            }
        }
        catch (Exception e) {
            Activator.log.error(String.format("Failed to access profile index for resource %s", uriToQuery), (Throwable)e);
        }
        return result;
    }

    private Set<ILanguage> getLanguages(Set<URI> profiles) {
        HashSet result;
        if (profiles.isEmpty()) {
            result = Collections.emptySet();
        } else {
            result = Sets.newHashSet();
            for (URI next : profiles) {
                ILanguage language = this.getLanguage(next);
                if (language == null) continue;
                result.add(language);
            }
        }
        return result;
    }

    protected synchronized ILanguage getLanguage(URI profileURI) {
        Bundle bundle;
        ILanguage result = null;
        String className = this.languageClasses.get(profileURI);
        if (className != null && (bundle = Platform.getBundle((String)this.config.getContributor().getName())) != null) {
            try {
                Class class_ = bundle.loadClass(className);
                if (class_ == null || !ILanguage.class.isAssignableFrom(class_)) {
                    this.languageClasses.remove(profileURI);
                    Activator.log.error(String.format("Not a language class for profile %s in contributor %s: %s", profileURI, this.config.getContributor().getName(), className), null);
                } else {
                    result = class_.asSubclass(ILanguage.class).newInstance();
                }
            }
            catch (Exception e) {
                this.languageClasses.remove(profileURI);
                Activator.log.error(String.format("Failed to instantiate language class %s for profile %s in contributor %s", className, profileURI, this.config.getContributor().getName()), (Throwable)e);
            }
        }
        return result;
    }
}

