/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class IndirectSet<E>
implements CollectionChangeTracker,
Set<E>,
IndirectCollection,
Cloneable,
Serializable {
    private volatile Set<E> delegate = null;
    private volatile ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener = null;
    private transient String attributeName = null;
    private transient Set<E> addedElements = null;
    private transient Set<E> removedElements = null;
    protected int initialCapacity = 10;
    protected float loadFactor = 0.75f;
    private boolean useLazyInstantiation = false;

    public IndirectSet() {
        this.valueHolder = null;
    }

    public IndirectSet(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.valueHolder = null;
    }

    public IndirectSet(int initialCapacity, float loadFactor) {
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.valueHolder = null;
    }

    public IndirectSet(Collection<? extends E> c) {
        this.valueHolder = new ValueHolder(new HashSet<E>(c));
    }

    protected boolean isRelationshipMaintenanceRequired() {
        if (this.valueHolder instanceof UnitOfWorkQueryValueHolder) {
            DatabaseMapping mapping = ((UnitOfWorkQueryValueHolder)this.valueHolder).getMapping();
            return mapping != null && mapping.getRelationshipPartner() != null;
        }
        return false;
    }

    @Override
    public boolean add(E element) {
        boolean added = true;
        if (this.shouldAvoidInstantiation()) {
            if (this.hasRemovedElements() && this.getRemovedElements().contains(element)) {
                this.getRemovedElements().remove(element);
            } else {
                if (this.isRelationshipMaintenanceRequired() && this.getAddedElements().contains(element)) {
                    return false;
                }
                this.getAddedElements().add(element);
            }
        } else {
            added = this.getDelegate().add(element);
        }
        if (added) {
            this.raiseAddChangeEvent(element);
        }
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator<E> objects = c.iterator();
            while (objects.hasNext()) {
                this.add(objects.next());
            }
            return true;
        }
        return this.getDelegate().addAll(c);
    }

    protected Set<E> buildDelegate() {
        Iterator<E> iterator;
        Set<E> newDelegate = (Set<E>)this.getValueHolder().getValue();
        if (newDelegate == null) {
            newDelegate = new HashSet(this.initialCapacity, this.loadFactor);
        }
        while (newDelegate instanceof IndirectSet) {
            newDelegate = ((IndirectSet)newDelegate).getDelegate();
        }
        if (this.hasAddedElements()) {
            iterator = this.getAddedElements().iterator();
            while (iterator.hasNext()) {
                newDelegate.add(iterator.next());
            }
            this.addedElements = null;
        }
        if (this.hasRemovedElements()) {
            iterator = this.getRemovedElements().iterator();
            while (iterator.hasNext()) {
                newDelegate.remove(iterator.next());
            }
            this.removedElements = null;
        }
        return newDelegate;
    }

    @Override
    public void clear() {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator<E> objects = this.iterator();
            while (objects.hasNext()) {
                objects.next();
                objects.remove();
            }
        }
        this.getDelegate().clear();
    }

    @Override
    public void clearDeferredChanges() {
        this.addedElements = null;
        this.removedElements = null;
    }

    public Object clone() {
        try {
            IndirectSet result = (IndirectSet)super.clone();
            result.delegate = this.cloneDelegate();
            result.valueHolder = new ValueHolder(result.delegate);
            result.attributeName = null;
            result.changeListener = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("clone not supported");
        }
    }

    protected Set<E> cloneDelegate() {
        Method cloneMethod;
        block13: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        cloneMethod = AccessController.doPrivileged(new PrivilegedGetMethod(this.getDelegate().getClass(), "clone", null, false));
                        break block13;
                    }
                    catch (PrivilegedActionException exception) {
                        throw QueryException.cloneMethodRequired();
                    }
                }
                cloneMethod = PrivilegedAccessHelper.getMethod(this.getDelegate().getClass(), "clone", null, false);
            }
            catch (NoSuchMethodException ex) {
                throw QueryException.cloneMethodRequired();
            }
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Set)AccessController.doPrivileged(new PrivilegedMethodInvoker(cloneMethod, this.getDelegate(), null));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof IllegalAccessException) {
                        throw QueryException.cloneMethodInaccessible();
                    }
                    if (throwableException instanceof InvocationTargetException) {
                        throw QueryException.cloneMethodThrowException(((InvocationTargetException)throwableException).getTargetException());
                    }
                    throw QueryException.cloneMethodThrowException(throwableException);
                }
            }
            return (Set)PrivilegedAccessHelper.invokeMethod(cloneMethod, this.getDelegate(), null);
        }
        catch (IllegalAccessException ex1) {
            throw QueryException.cloneMethodInaccessible();
        }
        catch (InvocationTargetException ex2) {
            throw QueryException.cloneMethodThrowException(ex2.getTargetException());
        }
    }

    @Override
    public boolean contains(Object element) {
        if (this.hasAddedElements() && this.getAddedElements().contains(element)) {
            return true;
        }
        if (this.hasRemovedElements() && this.getRemovedElements().contains(element)) {
            return false;
        }
        return this.getDelegate().contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getDelegate().containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.getDelegate().spliterator();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.getDelegate().parallelStream();
    }

    @Override
    public Stream<E> stream() {
        return this.getDelegate().stream();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            boolean hasChanged = false;
            Iterator<E> objects = this.iterator();
            while (objects.hasNext()) {
                if (!filter.test(objects.next())) continue;
                objects.remove();
                hasChanged |= true;
            }
            return hasChanged;
        }
        return this.getDelegate().removeIf(filter);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.getDelegate().forEach(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<E> getDelegate() {
        Set<E> newDelegate = this.delegate;
        if (newDelegate == null) {
            IndirectSet indirectSet = this;
            synchronized (indirectSet) {
                newDelegate = this.delegate;
                if (newDelegate == null) {
                    this.delegate = newDelegate = this.buildDelegate();
                }
            }
        }
        return newDelegate;
    }

    @Override
    public Object getDelegateObject() {
        return this.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueHolderInterface getValueHolder() {
        ValueHolderInterface vh = this.valueHolder;
        if (vh == null) {
            IndirectSet indirectSet = this;
            synchronized (indirectSet) {
                vh = this.valueHolder;
                if (vh == null) {
                    this.valueHolder = vh = new ValueHolder(new HashSet(this.initialCapacity, this.loadFactor));
                }
            }
        }
        return vh;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> delegateIterator;
            E currentObject;
            {
                this.delegateIterator = IndirectSet.this.getDelegate().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public E next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                IndirectSet.this.raiseRemoveChangeEvent(this.currentObject);
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                this.delegateIterator.forEachRemaining(action);
            }
        };
    }

    @Override
    public boolean remove(Object element) {
        if (this.shouldAvoidInstantiation()) {
            if (this.hasAddedElements() && this.getAddedElements().contains(element)) {
                this.getAddedElements().remove(element);
            } else {
                if (this.getRemovedElements().contains(element)) {
                    return false;
                }
                this.getRemovedElements().add(element);
            }
            this.raiseRemoveChangeEvent(element);
            return true;
        }
        if (this.getDelegate().remove(element)) {
            this.raiseRemoveChangeEvent(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator<?> objects = c.iterator();
            while (objects.hasNext()) {
                this.remove(objects.next());
            }
            return true;
        }
        return this.getDelegate().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator<E> objects = this.getDelegate().iterator();
            while (objects.hasNext()) {
                E object = objects.next();
                if (c.contains(object)) continue;
                objects.remove();
                this.raiseRemoveChangeEvent(object);
            }
            return true;
        }
        return this.getDelegate().retainAll(c);
    }

    @Override
    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
    }

    @Override
    public void setUseLazyInstantiation(boolean useLazyInstantiation) {
        this.useLazyInstantiation = useLazyInstantiation;
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    protected boolean shouldUseLazyInstantiation() {
        return this.useLazyInstantiation;
    }

    @Override
    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getDelegate().toArray(a);
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": " + ToStringLocalization.buildMessage("not_instantiated", null) + "}";
    }

    protected void raiseAddChangeEvent(Object element) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, element, 0, true));
        }
        if (this.isRelationshipMaintenanceRequired()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(element, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object element) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, element, 1, true));
        }
        if (this.isRelationshipMaintenanceRequired()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(element);
        }
    }

    @Override
    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    @Override
    public void _persistence_setPropertyChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    @Override
    public void setTrackedAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public Collection<E> getRemovedElements() {
        if (this.removedElements == null) {
            this.removedElements = new HashSet();
        }
        return this.removedElements;
    }

    @Override
    public Collection<E> getAddedElements() {
        if (this.addedElements == null) {
            this.addedElements = new HashSet();
        }
        return this.addedElements;
    }

    public boolean hasAddedElements() {
        return this.addedElements != null && !this.addedElements.isEmpty();
    }

    public boolean hasRemovedElements() {
        return this.removedElements != null && !this.removedElements.isEmpty();
    }

    @Override
    public boolean hasDeferredChanges() {
        return this.hasRemovedElements() || this.hasAddedElements();
    }

    protected boolean shouldAvoidInstantiation() {
        return !this.isInstantiated() && this.shouldUseLazyInstantiation() && this._persistence_getPropertyChangeListener() instanceof AttributeChangeListener && ((WeavedAttributeValueHolderInterface)this.getValueHolder()).shouldAllowInstantiationDeferral();
    }
}

