/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTPragma;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFG;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.OMPCFGMaker;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.RegionConcurrencyAnalysis;

public class FunctionConcurrencyAnalysis
extends ASTVisitor {
    protected IASTFunctionDefinition fDef_ = null;
    protected Hashtable pragmaRegionMap_ = null;
    protected Hashtable pragmaLocationMap_ = null;
    protected LinkedList components_ = new LinkedList();

    public FunctionConcurrencyAnalysis(IASTFunctionDefinition fDef, PASTOMPPragma[] pList) {
        this.fDef_ = fDef;
        this.pragmaRegionMap_ = this.buildRegionMap(pList);
        this.pragmaLocationMap_ = this.buildLocationMap(pList);
        this.shouldVisitStatements = true;
        this.fDef_.accept((ASTVisitor)this);
    }

    private void addComponent(RegionConcurrencyAnalysis component) {
        if (!this.components_.contains(component)) {
            this.components_.add(component);
            component.setParent(this);
        }
    }

    public RegionConcurrencyAnalysis[] getComponents() {
        RegionConcurrencyAnalysis[] list = new RegionConcurrencyAnalysis[this.components_.size()];
        int i = 0;
        while (i < list.length) {
            list[i] = (RegionConcurrencyAnalysis)this.components_.get(i);
            ++i;
        }
        return list;
    }

    public void doPhaseAnalysis() {
        for (RegionConcurrencyAnalysis occ : this.components_) {
            occ.doPhaseAnalysis();
        }
    }

    public Set getNodesConcurrentTo(IASTNode node) {
        for (RegionConcurrencyAnalysis component : this.components_) {
            Set s = component.getNodesConcurrentTo(node);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public void printAnalysis(PrintStream ps) {
        int count = 0;
        for (RegionConcurrencyAnalysis occ : this.components_) {
            ps.println("Component " + count + " ----------------------------------");
            occ.printComponent(ps);
            ++count;
        }
    }

    protected Hashtable buildRegionMap(PASTPragma[] pList) {
        Hashtable<IASTNode, PASTOMPPragma> map = new Hashtable<IASTNode, PASTOMPPragma>();
        int i = 0;
        while (i < pList.length) {
            PASTOMPPragma pragma;
            IASTNode region;
            if (pList[i] instanceof PASTOMPPragma && (region = (pragma = (PASTOMPPragma)pList[i]).getRegion()) != null && pragma.isCompiled() && this.isRegionDefinedInFctn(region)) {
                map.put(region, pragma);
            }
            ++i;
        }
        return map;
    }

    protected Hashtable buildLocationMap(PASTPragma[] pList) {
        Hashtable<IASTStatement, LinkedList<PASTOMPPragma>> map = new Hashtable<IASTStatement, LinkedList<PASTOMPPragma>>();
        int i = 0;
        while (i < pList.length) {
            PASTOMPPragma pragma;
            IASTStatement location;
            if (pList[i] instanceof PASTOMPPragma && (location = (pragma = (PASTOMPPragma)pList[i]).getLocation()) != null && pragma.isCompiled() && this.isRegionDefinedInFctn((IASTNode)location)) {
                LinkedList<PASTOMPPragma> l = (LinkedList<PASTOMPPragma>)map.get(location);
                if (l == null) {
                    l = new LinkedList<PASTOMPPragma>();
                    map.put(location, l);
                }
                l.add(pragma);
            }
            ++i;
        }
        return map;
    }

    public boolean isRegionDefinedInFctn(IASTNode node) {
        while (node != null) {
            if (node == this.fDef_) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public int visit(IASTStatement statement) {
        PASTOMPPragma pragma = (PASTOMPPragma)this.pragmaRegionMap_.get(statement);
        if (pragma != null) {
            this.buildRegionAnalysis(pragma, statement);
            return 1;
        }
        return 3;
    }

    protected void buildRegionAnalysis(PASTOMPPragma pragma, IASTStatement statement) {
        OMPCFG cfg = OMPCFGMaker.constructCFG(pragma, statement, this.pragmaRegionMap_, this.pragmaLocationMap_);
        cfg.printCFG(System.out);
        this.addComponent(new RegionConcurrencyAnalysis(cfg));
    }
}

