/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.propertyTesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ptp.internal.rm.lml.monitor.ui.handlers.ActionUtils;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.core.data.ControlType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.model.Row;

public class JobPropertyTester
extends PropertyTester {
    private static final String OUTPUT_READY = "outputReady";
    private static final String ERROR_READY = "errorReady";
    private static final String OPERATION_SUPPORTED = "operationSupported";
    private static final String JOB_STATE = "jobState";
    private static final String JOB_STATE_DETAIL = "jobStateDetail";
    private static final String AUTHORIZED = "authorized";
    private static final String JOB_STATUS_CMD = "GET_JOB_STATUS";

    protected boolean operationSupported(JobStatusData status, String operation) {
        ResourceManagerData data;
        ILaunchController jobController;
        String controlId = status.getString("controlId");
        if (controlId != null && (jobController = LaunchControllerManager.getInstance().getLaunchController(controlId)) != null && (data = jobController.getConfiguration()) != null) {
            ControlType control = data.getControlData();
            if (operation.equals(JOB_STATUS_CMD)) {
                return control.getGetJobStatus() != null;
            }
            if (operation.equals("HOLD")) {
                return control.getHoldJob() != null;
            }
            if (operation.equals("RELEASE")) {
                return control.getReleaseJob() != null;
            }
            if (operation.equals("RESUME")) {
                return control.getResumeJob() != null;
            }
            if (operation.equals("SUSPEND")) {
                return control.getSuspendJob() != null;
            }
            if (operation.equals("TERMINATE")) {
                return control.getTerminateJob() != null;
            }
        }
        return false;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof Row) {
            Row row = (Row)receiver;
            JobStatusData status = row.status;
            if (OUTPUT_READY.equals(property)) {
                return status.getOutReady() == this.toBoolean(expectedValue);
            }
            if (ERROR_READY.equals(property)) {
                return status.getErrReady() == this.toBoolean(expectedValue);
            }
            if (OPERATION_SUPPORTED.equals(property)) {
                return this.operationSupported(status, this.toString(expectedValue));
            }
            if (JOB_STATE.equals(property)) {
                return status.getState().equals(this.toString(expectedValue));
            }
            if (JOB_STATE_DETAIL.equals(property)) {
                return status.getStateDetail().equals(this.toString(expectedValue));
            }
            if (AUTHORIZED.equals(property)) {
                return ActionUtils.isAuthorised(status) == this.toBoolean(expectedValue);
            }
        }
        return false;
    }

    protected boolean toBoolean(Object expectedValue) {
        if (expectedValue instanceof Boolean) {
            return (Boolean)expectedValue;
        }
        return true;
    }

    protected String toString(Object expectedValue) {
        return expectedValue == null ? "" : expectedValue.toString();
    }
}

