/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;

public final class URIMigrationUtils {
    private static final String SEGMENT_SEPARATOR = "/";
    private static final String FRAGMENT_SEPARATOR = "#";
    private static final String VIEW_EXTENSION_DESCRIPTION_SEGMENT = "@extensions.";
    private static final String FIRST_CATEGORY_SEGMENT = "/@categories.0";

    private URIMigrationUtils() {
    }

    public static List<URI> createProxyURIsWithCategories(URI resourceURI, String values) {
        ArrayList<URI> uris = new ArrayList<URI>();
        StringTokenizer tokenizer = new StringTokenizer(values, " ");
        while (tokenizer.hasMoreTokens()) {
            String value = tokenizer.nextToken();
            String[] segments = value.split(SEGMENT_SEPARATOR);
            String proxyURI = Arrays.stream(segments).map(segment -> {
                if (segment.contains(VIEW_EXTENSION_DESCRIPTION_SEGMENT)) {
                    return String.valueOf(segment) + FIRST_CATEGORY_SEGMENT;
                }
                return segment;
            }).collect(Collectors.joining(SEGMENT_SEPARATOR));
            if (proxyURI.contains(FRAGMENT_SEPARATOR)) {
                uris.add(URI.createURI((String)proxyURI));
                continue;
            }
            uris.add(resourceURI.appendFragment(proxyURI));
        }
        return uris;
    }
}

