/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2containment;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2edge;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Param2item;
import org.eclipse.viatra.addon.viewers.runtime.notation.Containment;
import org.eclipse.viatra.addon.viewers.runtime.notation.Edge;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public final class ViewerTraceabilityUtil {
    private ViewerTraceabilityUtil() {
    }

    public static Collection<Item> traceToItem(ViatraQueryEngine engine, Object source) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2item.Match> allMatches = ViewerTraceabilityUtil.executeParam2itemMatcher(engine, source);
        for (Param2item.Match match : allMatches) {
            list.add(match.getItem());
        }
        return list;
    }

    private static Collection<Param2item.Match> executeParam2itemMatcher(ViatraQueryEngine engine, Object source) {
        try {
            Param2item.Matcher matcher = Param2item.Matcher.on(engine);
            return matcher.getAllMatches(source, null, null);
        }
        catch (ViatraQueryException e) {
            Logger logger = ViatraQueryLoggingUtil.getLogger(ViewerTraceabilityUtil.class);
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Collection<Edge> traceToEdge(ViatraQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2edge.Match> allMatches = ViewerTraceabilityUtil.executeParam2edgeMatcher(engine, source, target);
        for (Param2edge.Match match : allMatches) {
            list.add(match.getEdge());
        }
        return list;
    }

    private static Collection<Param2edge.Match> executeParam2edgeMatcher(ViatraQueryEngine engine, Object source, Object target) {
        try {
            Param2edge.Matcher matcher = Param2edge.Matcher.on(engine);
            return matcher.getAllMatches(source, target, null, null);
        }
        catch (ViatraQueryException e) {
            Logger logger = ViatraQueryLoggingUtil.getLogger(ViewerTraceabilityUtil.class);
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Collection<Containment> traceTocontainment(ViatraQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2containment.Match> allMatches = ViewerTraceabilityUtil.executeParam2containmentMatcher(engine, source, target);
        for (Param2containment.Match match : allMatches) {
            list.add(match.getContainment());
        }
        return list;
    }

    private static Collection<Param2containment.Match> executeParam2containmentMatcher(ViatraQueryEngine engine, Object source, Object target) {
        try {
            Param2containment.Matcher matcher = Param2containment.Matcher.on(engine);
            return matcher.getAllMatches(source, target, null, null);
        }
        catch (ViatraQueryException e) {
            Logger logger = ViatraQueryLoggingUtil.getLogger(ViewerTraceabilityUtil.class);
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Collection<Item> deleteTracesAndItems(ViatraQueryEngine engine, Object source) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2item.Match> allMatches = ViewerTraceabilityUtil.executeParam2itemMatcher(engine, source);
        for (Param2item.Match match : allMatches) {
            EcoreUtil.delete((EObject)match.getTrace());
            EcoreUtil.delete((EObject)match.getItem());
            list.add(match.getItem());
        }
        return list;
    }

    public static Collection<Edge> deleteTracesAndEdges(ViatraQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2edge.Match> allMatches = ViewerTraceabilityUtil.executeParam2edgeMatcher(engine, source, target);
        for (Param2edge.Match match : allMatches) {
            EcoreUtil.delete((EObject)match.getTrace());
            EcoreUtil.delete((EObject)match.getEdge());
            list.add(match.getEdge());
        }
        return list;
    }

    public static Collection<Containment> deleteTracesAndContainments(ViatraQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2containment.Match> allMatches = ViewerTraceabilityUtil.executeParam2containmentMatcher(engine, source, target);
        for (Param2containment.Match match : allMatches) {
            match.getContainment().getTarget().setParent(null);
            EcoreUtil.delete((EObject)match.getTrace());
            EcoreUtil.delete((EObject)match.getContainment());
            list.add(match.getContainment());
        }
        return list;
    }
}

