/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.model.EGFModelPlugin;
import org.eclipse.egf.model.pattern.AbstractPatternCall;
import org.eclipse.egf.model.pattern.BackCall;
import org.eclipse.egf.model.pattern.BasicQuery;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.CustomQuery;
import org.eclipse.egf.model.pattern.InjectedContext;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternNameHelper;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.PatternViewpoint;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.model.pattern.StringQuery;
import org.eclipse.egf.model.pattern.Substitution;
import org.eclipse.egf.model.pattern.SuperCall;
import org.eclipse.egf.model.pattern.TypePatternCallBackHandler;
import org.eclipse.egf.model.pattern.TypePatternDomainVisitor;
import org.eclipse.egf.model.pattern.TypePatternExecutionReporter;
import org.eclipse.egf.model.pattern.TypePatternList;
import org.eclipse.egf.model.pattern.TypePatternOutputProcessor;
import org.eclipse.egf.model.pattern.TypePatternSubstitution;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.egf.model.types.util.TypesValidator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternValidator
extends EObjectValidator {
    public static final PatternValidator INSTANCE = new PatternValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model.pattern";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private final IBatchValidator batchValidator;
    protected TypesValidator typesValidator = TypesValidator.INSTANCE;

    public PatternValidator() {
        this.batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    protected EPackage getEPackage() {
        return PatternPackage.eINSTANCE;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = Status.OK_STATUS;
        super.validate(eClass, eObject, diagnostics, context);
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePatternNature((PatternNature)value, diagnostics, context);
            }
            case 1: {
                return this.validatePatternElement((PatternElement)value, diagnostics, context);
            }
            case 2: {
                return this.validatePatternLibrary((PatternLibrary)value, diagnostics, context);
            }
            case 3: {
                return this.validatePattern((Pattern)value, diagnostics, context);
            }
            case 4: {
                return this.validatePatternMethod((PatternMethod)value, diagnostics, context);
            }
            case 5: {
                return this.validatePatternParameter((PatternParameter)value, diagnostics, context);
            }
            case 6: {
                return this.validatePatternViewpoint((PatternViewpoint)value, diagnostics, context);
            }
            case 7: {
                return this.validatePatternCall((PatternCall)value, diagnostics, context);
            }
            case 8: {
                return this.validateSuperCall((SuperCall)value, diagnostics, context);
            }
            case 9: {
                return this.validateParamerter2ParameterMap((Map.Entry)value, diagnostics, context);
            }
            case 10: {
                return this.validateCall((Call)value, diagnostics, context);
            }
            case 11: {
                return this.validateMethodCall((MethodCall)value, diagnostics, context);
            }
            case 12: {
                return this.validatePatternVariable((PatternVariable)value, diagnostics, context);
            }
            case 13: {
                return this.validateAbstractPatternCall((AbstractPatternCall)value, diagnostics, context);
            }
            case 14: {
                return this.validatePatternInjectedCall((PatternInjectedCall)value, diagnostics, context);
            }
            case 15: {
                return this.validateQuery((Query)value, diagnostics, context);
            }
            case 16: {
                return this.validateBasicQuery((BasicQuery)value, diagnostics, context);
            }
            case 17: {
                return this.validateStringQuery((StringQuery)value, diagnostics, context);
            }
            case 18: {
                return this.validateCustomQuery((CustomQuery)value, diagnostics, context);
            }
            case 19: {
                return this.validateString2PatternList((Map.Entry)value, diagnostics, context);
            }
            case 20: {
                return this.validateString2String((Map.Entry)value, diagnostics, context);
            }
            case 21: {
                return this.validateBackCall((BackCall)value, diagnostics, context);
            }
            case 22: {
                return this.validateInjectedContext((InjectedContext)value, diagnostics, context);
            }
            case 23: {
                return this.validateSubstitution((Substitution)value, diagnostics, context);
            }
            case 24: {
                return this.validateTypePatternExecutionReporter((TypePatternExecutionReporter)value, diagnostics, context);
            }
            case 25: {
                return this.validateTypePatternCallBackHandler((TypePatternCallBackHandler)value, diagnostics, context);
            }
            case 26: {
                return this.validateTypePatternDomainVisitor((TypePatternDomainVisitor)value, diagnostics, context);
            }
            case 27: {
                return this.validateTypePatternList((TypePatternList)value, diagnostics, context);
            }
            case 28: {
                return this.validateTypePatternSubstitution((TypePatternSubstitution)value, diagnostics, context);
            }
            case 29: {
                return this.validateTypePatternOutputProcessor((TypePatternOutputProcessor)value, diagnostics, context);
            }
            case 30: {
                return this.validatePatternContext((PatternContext)value, diagnostics, context);
            }
            case 31: {
                return this.validatePatternException((PatternException)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePattern(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(pattern, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(pattern, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePatternElement_MandatoryName(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePattern_UniqueName(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePattern_HeaderMethod(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePattern_FooterMethod(pattern, diagnostics, context);
        }
        return result;
    }

    public boolean validatePattern_UniqueName(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (pattern.getName() == null || pattern.getName().trim().length() == 0 || pattern.eResource() == null || !(pattern.eResource() instanceof IPlatformFcoreProvider)) {
            return true;
        }
        if (PatternNameHelper.getPatternNameWithinBundle(((IPlatformFcoreProvider)pattern.eResource()).getIPlatformFcore(), pattern.getContainer(), pattern).contains(pattern.getName())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"UniqueName", PatternValidator.getObjectLabel((EObject)pattern, context), NLS.bind((String)"Pattern name ''{0}'' is not unique", (Object)pattern.getName())}, new Object[]{pattern}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePattern_HeaderMethod(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (pattern.getHeaderMethod() != null && !pattern.getMethods().contains((Object)pattern.getHeaderMethod())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"HeaderMethod", PatternValidator.getObjectLabel((EObject)pattern, context), "Header Method should be a Pattern Method"}, new Object[]{pattern}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePattern_FooterMethod(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (pattern.getFooterMethod() != null && !pattern.getMethods().contains((Object)pattern.getFooterMethod())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"FooterMethod", PatternValidator.getObjectLabel((EObject)pattern, context), "Footer Method should be a Pattern Method"}, new Object[]{pattern}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePatternMethod(PatternMethod patternMethod, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(patternMethod, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(patternMethod, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(patternMethod, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(patternMethod, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(patternMethod, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(patternMethod, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(patternMethod, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(patternMethod, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePatternMethod_MandatoryName(patternMethod, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePatternMethod_ValidURI(patternMethod, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePatternMethod_ValidPatternFilePath(patternMethod, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternMethod_MandatoryName(PatternMethod patternMethod, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (patternMethod.getName() == null || patternMethod.getName().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"MandatoryName", PatternValidator.getObjectLabel((EObject)patternMethod, context), "The attribute name is mandatory"}, new Object[]{patternMethod}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePatternMethod_ValidURI(PatternMethod method, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (method.getPatternFilePath() == null || method.eResource() == null) {
            return true;
        }
        URI uri = method.getPatternFilePath();
        boolean valid = true;
        InputStream inputStream = null;
        try {
            inputStream = TemplateModelFileHelper.getInputStream(method);
        }
        catch (IOException exception) {
            valid = false;
        }
        FileHelper.safeClose((InputStream)inputStream);
        if (!valid) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidURI", method.getName() != null ? method.getName() : PatternValidator.getObjectLabel((EObject)method, context), NLS.bind((String)"Unable to load URI ''{0}''", (Object)uri)}, new Object[]{method.getPattern()}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePatternMethod_ValidPatternFilePath(PatternMethod method, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (method.getPatternFilePath() == null || method.eResource() == null) {
            return true;
        }
        boolean valid = true;
        String patternId = null;
        String methodId = null;
        try {
            patternId = TemplateModelFileHelper.extractPatternId((IPath)new Path(method.getPatternFilePath().toPlatformString(true)));
            methodId = TemplateModelFileHelper.extractPatternMethodId((IPath)new Path(method.getPatternFilePath().toPlatformString(true)));
        }
        catch (TemplateModelFileHelper.FilenameFormatException ffe) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidPatternFilePath", method.getName() != null ? method.getName() : PatternValidator.getObjectLabel((EObject)method, context), ffe.getMessage()}, new Object[]{method.getPattern()}, context));
            }
            return false;
        }
        if (!method.getPattern().getID().equals(patternId)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidPatternFilePath", method.getName() != null ? method.getName() : PatternValidator.getObjectLabel((EObject)method, context), NLS.bind((String)"Pattern ID doesn''t match ''{0}'' found ''{1}''", (Object[])new Object[]{method.getPattern().getID(), patternId})}, new Object[]{method.getPattern()}, context));
            }
            valid = false;
        }
        if (!method.getID().equals(methodId)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidPatternFilePath", method.getName() != null ? method.getName() : PatternValidator.getObjectLabel((EObject)method, context), NLS.bind((String)"PatternMethod ID doesn''t match ''{0}'' found ''{1}''", (Object[])new Object[]{method.getID(), methodId})}, new Object[]{method.getPattern()}, context));
            }
            valid = false;
        }
        if (method.getPatternFilePath().isPlatform()) {
            String methodBundle;
            String patternFilePathBundle = method.getPatternFilePath().segment(1);
            URI methodBundleURI = method.eResource().getURI();
            if (patternFilePathBundle != null && methodBundleURI.isPlatform() && !patternFilePathBundle.equals(methodBundle = methodBundleURI.segment(1))) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidPatternFilePath", method.getName() != null ? method.getName() : PatternValidator.getObjectLabel((EObject)method, context), NLS.bind((String)"PatternMethod Bundle ''{0}'' doesn't match PatternFilePath Bundle ''{1}''", (Object[])new Object[]{methodBundle, patternFilePathBundle})}, new Object[]{method.getPattern()}, context));
                }
                valid = false;
            }
        }
        return valid;
    }

    public boolean validatePatternParameter(PatternParameter patternParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(patternParameter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(patternParameter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(patternParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(patternParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(patternParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(patternParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(patternParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(patternParameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePatternParameter_MandatoryName(patternParameter, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternParameter_MandatoryName(PatternParameter patternParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (patternParameter.getName() == null || patternParameter.getName().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"MandatoryName", PatternValidator.getObjectLabel((EObject)patternParameter, context), "The attribute name is mandatory"}, new Object[]{patternParameter}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePatternLibrary(PatternLibrary patternLibrary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(patternLibrary, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(patternLibrary, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(patternLibrary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePatternElement_MandatoryName(patternLibrary, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternElement(PatternElement patternElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(patternElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(patternElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(patternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(patternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(patternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(patternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(patternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(patternElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePatternElement_MandatoryName(patternElement, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternElement_MandatoryName(PatternElement patternElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (patternElement.getName() == null || patternElement.getName().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"MandatoryName", PatternValidator.getObjectLabel((EObject)patternElement, context), "The attribute name is mandatory"}, new Object[]{patternElement}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePatternViewpoint(PatternViewpoint patternViewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternViewpoint, diagnostics, context);
    }

    public boolean validatePatternNature(PatternNature patternNature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(patternNature, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(patternNature, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(patternNature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(patternNature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(patternNature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(patternNature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(patternNature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(patternNature, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePatternNature_MandatoryName(patternNature, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternNature_MandatoryName(PatternNature patternNature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (patternNature.getName() == null || patternNature.getName().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"MandatoryName", PatternValidator.getObjectLabel((EObject)patternNature, context), "The attribute name is mandatory"}, new Object[]{patternNature}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePatternCall(PatternCall patternCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternCall, diagnostics, context);
    }

    public boolean validateSuperCall(SuperCall superCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(superCall, diagnostics, context);
    }

    public boolean validateParamerter2ParameterMap(Map.Entry<?, ?> paramerter2ParameterMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)paramerter2ParameterMap, diagnostics, context);
    }

    public boolean validateCall(Call call, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(call, diagnostics, context);
    }

    public boolean validateMethodCall(MethodCall methodCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(methodCall, diagnostics, context);
    }

    public boolean validatePatternVariable(PatternVariable patternVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(patternVariable, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(patternVariable, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(patternVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(patternVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(patternVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(patternVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(patternVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(patternVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePatternVariable_MandatoryName(patternVariable, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternVariable_MandatoryName(PatternVariable patternVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (patternVariable.getName() == null || patternVariable.getName().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"MandatoryName", PatternValidator.getObjectLabel((EObject)patternVariable, context), "The attribute name is mandatory"}, new Object[]{patternVariable}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateAbstractPatternCall(AbstractPatternCall abstractPatternCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abstractPatternCall, diagnostics, context);
    }

    public boolean validatePatternInjectedCall(PatternInjectedCall patternInjectedCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternInjectedCall, diagnostics, context);
    }

    public boolean validateQuery(Query query, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(query, diagnostics, context);
    }

    public boolean validateBasicQuery(BasicQuery basicQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(basicQuery, diagnostics, context);
    }

    public boolean validateStringQuery(StringQuery stringQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(stringQuery, diagnostics, context);
    }

    public boolean validateCustomQuery(CustomQuery customQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(customQuery, diagnostics, context);
    }

    public boolean validateString2PatternList(Map.Entry<?, ?> string2PatternList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)string2PatternList, diagnostics, context);
    }

    public boolean validateString2String(Map.Entry<?, ?> string2String, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)string2String, diagnostics, context);
    }

    public boolean validateTypePatternExecutionReporter(TypePatternExecutionReporter typePatternExecutionReporter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typePatternExecutionReporter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typePatternExecutionReporter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_LoadableType(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_ValidValue(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_ValidInstance(typePatternExecutionReporter, diagnostics, context);
        }
        return result;
    }

    public boolean validateBackCall(BackCall backCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(backCall, diagnostics, context);
    }

    public boolean validateTypePatternCallBackHandler(TypePatternCallBackHandler typePatternCallBackHandler, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typePatternCallBackHandler, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typePatternCallBackHandler, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typePatternCallBackHandler, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typePatternCallBackHandler, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typePatternCallBackHandler, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typePatternCallBackHandler, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typePatternCallBackHandler, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typePatternCallBackHandler, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_LoadableType(typePatternCallBackHandler, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_ValidValue(typePatternCallBackHandler, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_ValidInstance(typePatternCallBackHandler, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypePatternDomainVisitor(TypePatternDomainVisitor typePatternDomainVisitor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typePatternDomainVisitor, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typePatternDomainVisitor, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typePatternDomainVisitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typePatternDomainVisitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typePatternDomainVisitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typePatternDomainVisitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typePatternDomainVisitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typePatternDomainVisitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_LoadableType(typePatternDomainVisitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_ValidValue(typePatternDomainVisitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_ValidInstance(typePatternDomainVisitor, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypePatternList(TypePatternList typePatternList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(typePatternList, diagnostics, context);
    }

    public boolean validateInjectedContext(InjectedContext injectedContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(injectedContext, diagnostics, context);
    }

    public boolean validateTypePatternSubstitution(TypePatternSubstitution typePatternSubstitution, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(typePatternSubstitution, diagnostics, context);
    }

    public boolean validateTypePatternOutputProcessor(TypePatternOutputProcessor typePatternOutputProcessor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typePatternOutputProcessor, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typePatternOutputProcessor, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typePatternOutputProcessor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typePatternOutputProcessor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typePatternOutputProcessor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typePatternOutputProcessor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typePatternOutputProcessor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typePatternOutputProcessor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_LoadableType(typePatternOutputProcessor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_ValidValue(typePatternOutputProcessor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_ValidInstance(typePatternOutputProcessor, diagnostics, context);
        }
        return result;
    }

    public boolean validateSubstitution(Substitution substitution, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(substitution, diagnostics, context);
    }

    public boolean validatePatternContext(PatternContext patternContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePatternException(PatternException patternException, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return EGFModelPlugin.INSTANCE;
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

