/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.RotateEvent;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnRotateHandler;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.TransformPolicy;

public class RotateSelectedOnRotateHandler
extends AbstractHandler
implements IOnRotateHandler {
    private Point pivotInScene;
    private Map<IContentPart<? extends Node>, Integer> rotationIndices = new HashMap<IContentPart<? extends Node>, Integer>();
    private List<IContentPart<? extends Node>> targetParts;
    private boolean invalidGesture = false;

    @Override
    public void abortRotate() {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            TransformPolicy transformPolicy = this.getTransformPolicy(iVisualPart);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(iVisualPart);
            this.rollback(transformPolicy);
        }
    }

    protected List<IContentPart<? extends Node>> determineTargetParts() {
        return ((SelectionModel)((Object)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class))).getSelectionUnmodifiable();
    }

    @Override
    public void endRotate(RotateEvent e) {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, iVisualPart);
            TransformPolicy transformPolicy = this.getTransformPolicy(iVisualPart);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(iVisualPart);
            this.commit(transformPolicy);
        }
    }

    protected List<IContentPart<? extends Node>> getTargetParts() {
        return this.targetParts;
    }

    protected TransformPolicy getTransformPolicy(IVisualPart<? extends Node> part) {
        return (TransformPolicy)part.getAdapter(TransformPolicy.class);
    }

    protected boolean isRotate(RotateEvent event) {
        return true;
    }

    @Override
    public void rotate(RotateEvent e) {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, iVisualPart);
        }
    }

    @Override
    public void startRotate(RotateEvent e) {
        this.targetParts = this.determineTargetParts();
        boolean bl = this.invalidGesture = !this.isRotate(e);
        if (this.invalidGesture) {
            return;
        }
        Rectangle bounds = PartUtils.getUnionedVisualBoundsInScene(this.targetParts);
        if (bounds == null) {
            throw new IllegalStateException("Cannot determine visual bounds (null).");
        }
        this.pivotInScene = bounds.getCenter();
        this.rotationIndices.clear();
        for (IContentPart<? extends Node> part : this.getTargetParts()) {
            TransformPolicy transformPolicy = this.getTransformPolicy(part);
            if (transformPolicy == null) continue;
            this.storeAndDisableRefreshVisuals(part);
            this.init(transformPolicy);
            Point pivotInLocal = FX2Geometry.toPoint((Point2D)this.getHost().getVisual().getParent().sceneToLocal(this.pivotInScene.x, this.pivotInScene.y));
            int translateIndex = transformPolicy.createPostTransform();
            int rotateIndex = transformPolicy.createPostTransform();
            int translateBackIndex = transformPolicy.createPostTransform();
            transformPolicy.setPostTranslate(translateIndex, -pivotInLocal.x, -pivotInLocal.y);
            transformPolicy.setPostTranslate(translateBackIndex, pivotInLocal.x, pivotInLocal.y);
            this.rotationIndices.put(part, rotateIndex);
        }
    }

    private void updateOperation(RotateEvent e, IVisualPart<? extends Node> part) {
        Angle rotationAngle = Angle.fromDeg((double)e.getTotalAngle());
        TransformPolicy transformPolicy = this.getTransformPolicy(part);
        if (transformPolicy != null) {
            transformPolicy.setPostRotate(this.rotationIndices.get(part), rotationAngle);
        }
    }
}

