/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;

public class JBExecutors {
    private JBExecutors() {
    }

    public static ThreadFactory daemonThreadFactory(String poolName) {
        return new DaemonThreadFactory(poolName);
    }

    public static ExecutorService newSingleDaemonThreadExecutor(String poolName) {
        return Executors.newSingleThreadExecutor(JBExecutors.daemonThreadFactory(poolName));
    }

    public static ScheduledExecutorService newSingleDaemonThreadScheduledExecutor(String poolName) {
        return Executors.newSingleThreadScheduledExecutor(JBExecutors.daemonThreadFactory(poolName));
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final String m_poolName;
        private final AtomicInteger m_threadNumber;

        public DaemonThreadFactory(String poolName) {
            Validate.notNull((Object)poolName);
            this.m_poolName = String.valueOf(poolName) + "-";
            this.m_threadNumber = new AtomicInteger();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread newThread = new Thread(r, String.valueOf(this.m_poolName) + this.m_threadNumber.incrementAndGet());
            newThread.setDaemon(true);
            return newThread;
        }
    }
}

