/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JList;
import javax.swing.plaf.basic.ComboPopup;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.ObjectMappedMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.PropertyUtil;
import org.eclipse.jubula.rc.swing.listener.AbstractAutSwingEventListener;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;
import org.eclipse.jubula.rc.swing.tester.util.TesterUtil;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;

public class MappingListener
extends AbstractAutSwingEventListener {
    private static AutServerLogger log = new AutServerLogger(MappingListener.class);

    protected void handleEvent(AWTEvent event) {
        block12: {
            if (event.equals(this.getLastEvent())) {
                return;
            }
            this.setLastEvent(event);
            try {
                if (event instanceof KeyEvent || event instanceof MouseEvent && ((MouseEvent)event).getID() == 500) {
                    this.handleInputEvent((InputEvent)event);
                    break block12;
                }
                Component source = this.getEventSource(event);
                if (source == null || this.isComboPopup(source)) {
                    return;
                }
                Container parent = source.getParent();
                Object implClass = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(event.paramString()) + ",source:" + source.toString() + ",class:" + source.getClass().getName()));
                }
                if (parent != null) {
                    try {
                        implClass = AUTServerConfiguration.getInstance().getImplementationClass(parent.getClass());
                        source = parent;
                    }
                    catch (UnsupportedComponentException unsupportedComponentException) {}
                }
                if (implClass == null) {
                    try {
                        implClass = AUTServerConfiguration.getInstance().getImplementationClass(source.getClass());
                    }
                    catch (UnsupportedComponentException unsupportedComponentException) {
                        return;
                    }
                }
                this.switchEvent(event, source, implClass);
            }
            catch (ClassCastException cce) {
                log.error((Object)cce);
            }
        }
    }

    private boolean isComboPopup(Component source) {
        if (source instanceof ComboPopup) {
            return true;
        }
        if (source instanceof JList) {
            Container parent = source.getParent();
            while (parent != null) {
                if (parent instanceof ComboPopup) {
                    return true;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    protected void switchEvent(AWTEvent event, Component source, Object implClass) {
        Color highlightColor = null;
        switch (event.getID()) {
            case 501: 
            case 502: {
                this.highlightClicked(implClass, highlightColor);
                break;
            }
            case 503: 
            case 504: {
                this.highlight(source, implClass, highlightColor);
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("event occurred: " + event.paramString()));
            }
        }
        int eventId = event.getID();
        if (eventId >= 100 && eventId <= 103 || eventId >= 800 && eventId <= 801 || eventId >= 200 && eventId <= 209) {
            this.updateHighlighting(source, implClass, highlightColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInputEvent(InputEvent event) {
        if (event.getID() != 401 && event.getID() != 500) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("handleKeyEvent: event = " + event.paramString()));
        }
        Object object = this.getComponentLock();
        synchronized (object) {
            Component bean = this.getCurrentComponent();
            if (bean != null && this.getAcceptor().accept(event) == 1) {
                try {
                    IComponentIdentifier id = ComponentHandler.getIdentifier(bean);
                    Map componentProperties = PropertyUtil.getMapOfComponentProperties((Object)bean);
                    id.setComponentPropertiesMap(componentProperties);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("send a message with identifier for the component '" + id + "'"));
                    }
                    ObjectMappedMessage message = new ObjectMappedMessage();
                    message.setComponentIdentifier(id);
                    AUTServer.getInstance().getCommunicator().send((Message)message);
                }
                catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                    log.error((Object)("no identifier for '" + bean));
                }
                catch (CommunicationException ce) {
                    log.error((Object)ce);
                }
            }
        }
    }

    public void update() {
        Color highlightColor = null;
        if (this.getCurrentComponent() != null) {
            try {
                AUTServerConfiguration.getInstance().getImplementationClass(MappingListener.getComponentClass(this.getCurrentComponent()));
                TesterUtil.highLight(this.getCurrentComponent(), highlightColor);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"unexpected exception", (Throwable)e);
            }
            catch (UnsupportedComponentException unsupportedComponentException) {}
        }
    }

    public boolean highlightComponent(IComponentIdentifier compId) {
        block7: {
            Color highlightColor = null;
            Component component = null;
            try {
                if (this.getCurrentComponent() != null) {
                    AUTServerConfiguration.getInstance().getImplementationClass(MappingListener.getComponentClass(this.getCurrentComponent()));
                    TesterUtil.lowLight(this.getCurrentComponent());
                    this.setHighLighted(false);
                }
                if ((component = ComponentHandler.findComponent(compId, false, 0)) != null) {
                    this.setCurrentComponent(component);
                    if (this.getCurrentComponent() != null && this.getCurrentComponent().isShowing() && this.getCurrentComponent().isVisible()) {
                        AUTServerConfiguration.getInstance().getImplementationClass(MappingListener.getComponentClass(this.getCurrentComponent()));
                        TesterUtil.highLight(this.getCurrentComponent(), highlightColor);
                        this.setHighLighted(true);
                        return true;
                    }
                    break block7;
                }
                return false;
            }
            catch (ComponentNotFoundException e) {
                log.warn((Object)e);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)e);
            }
            catch (UnsupportedComponentException uce) {
                log.warn((Object)uce);
            }
        }
        return false;
    }
}

