/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.constants;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.tools.internal.i18n.I18n;

public class InputCodeHelper {
    private static InputCodeHelper instance = null;
    private int[] m_modifier = new int[6];
    private UserInput[] m_keys;
    private UserInput[] m_inputs;
    private String[] m_inputStrings;
    private String[] m_keyStrings;
    private String[] m_modifierString;

    private InputCodeHelper() {
        this.m_modifier[0] = 128;
        this.m_modifier[1] = 192;
        this.m_modifier[2] = 640;
        this.m_modifier[3] = 512;
        this.m_modifier[4] = 576;
        this.m_modifier[5] = 0;
        ArrayList<UserInput> inputList = new ArrayList<UserInput>();
        ArrayList<String> inputStringList = new ArrayList<String>();
        int i = 48;
        while (i <= 57) {
            inputList.add(new UserInput(i, 1));
            inputStringList.add(KeyEvent.getKeyText(i));
            ++i;
        }
        i = 65;
        while (i <= 90) {
            inputList.add(new UserInput(i, 1));
            inputStringList.add(KeyEvent.getKeyText(i));
            ++i;
        }
        i = 96;
        while (i <= 107) {
            inputList.add(new UserInput(i, 1));
            inputStringList.add(KeyEvent.getKeyText(i));
            ++i;
        }
        i = 109;
        while (i <= 111) {
            inputList.add(new UserInput(i, 1));
            inputStringList.add(KeyEvent.getKeyText(i));
            ++i;
        }
        i = 112;
        while (i <= 123) {
            inputList.add(new UserInput(i, 1));
            inputStringList.add(KeyEvent.getKeyText(i));
            ++i;
        }
        this.m_modifierString = new String[this.m_modifier.length];
        i = 0;
        while (i < this.m_modifier.length) {
            this.m_modifierString[i] = InputEvent.getModifiersExText(this.m_modifier[i]);
            ++i;
        }
        this.m_keys = inputList.toArray(new UserInput[inputList.size()]);
        this.m_keyStrings = inputStringList.toArray(new String[inputStringList.size()]);
        inputList.add(new UserInput(1, 2));
        inputList.add(new UserInput(2, 2));
        inputList.add(new UserInput(3, 2));
        inputStringList.add(I18n.getString("ObjectMappingPreferencePageMouseButton1"));
        inputStringList.add(I18n.getString("ObjectMappingPreferencePageMouseButton2"));
        inputStringList.add(I18n.getString("ObjectMappingPreferencePageMouseButton3"));
        this.m_inputs = inputList.toArray(new UserInput[inputList.size()]);
        this.m_inputStrings = inputStringList.toArray(new String[inputStringList.size()]);
    }

    public static InputCodeHelper getInstance() {
        if (instance == null) {
            instance = new InputCodeHelper();
        }
        return instance;
    }

    public UserInput[] getKeys() {
        return this.m_keys;
    }

    public UserInput[] getInputs() {
        return this.m_inputs;
    }

    public String[] getInputStrings() {
        return this.m_inputStrings;
    }

    public String[] getKeyStrings() {
        return this.m_keyStrings;
    }

    public int[] getModifier() {
        return this.m_modifier;
    }

    public String[] getModifierString() {
        return this.m_modifierString;
    }

    public int getIndexOfModifier(int modifier) {
        return ArrayUtils.indexOf((int[])this.m_modifier, (int)modifier);
    }

    public static class UserInput {
        private int m_type;
        private int m_code;

        public UserInput(int code, int type) {
            this.m_code = code;
            this.m_type = type;
        }

        public int getCode() {
            return this.m_code;
        }

        public int getType() {
            return this.m_type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UserInput) {
                UserInput input = (UserInput)obj;
                return new EqualsBuilder().append(this.getCode(), input.getCode()).append(this.getType(), input.getType()).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.getCode()).append(this.getType()).toHashCode();
        }
    }
}

