/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Iterator;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="arrays_grouped_by_size")
@Icon(value="/META-INF/icons/array_size.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
@Subjects(value={"byte[]", "boolean[]", "short[]", "char[]", "int[]", "float[]", "long[]", "double[]", "java.lang.Object[]"})
public class ArraysBySizeQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.ArraysBySizeQuery_ExtractingArraySizes);
        Quantize.Builder builder = Quantize.valueDistribution((Column[])new Column[]{new Column(Messages.ArraysBySizeQuery_ColumnLength, Integer.TYPE)});
        builder.column(Messages.ArraysBySizeQuery_ColumnNumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_LONG, Column.SortDirection.DESC);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                if (this.snapshot.isArray(objectId)) {
                    long size = this.snapshot.getHeapSize(objectId);
                    quantize.addValue(objectId, new Object[]{size, null, size});
                }
                ++n2;
            }
        }
        return quantize.getResult();
    }
}

