/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot;

import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.snapshot.HeapObjectArgumentFactory;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapObjectContextArgument
extends HeapObjectArgumentFactory {
    List<IContextObject> context;
    String label;

    public HeapObjectContextArgument(ISnapshot snapshot, List<IContextObject> context, String label) {
        super(snapshot);
        this.context = context;
        this.label = label;
    }

    public String toString() {
        return this.label != null ? "[" + this.label + "]" : Messages.HeapObjectContextArgument_Label_Context;
    }

    public void appendUsage(StringBuilder buf) {
        buf.append(this.toString());
    }

    @Override
    protected int[] asIntegerArray() throws SnapshotException {
        return this.asObjectArgument().getIds((IProgressListener)new VoidProgressListener());
    }

    @Override
    protected IHeapObjectArgument asObjectArgument() {
        return new IHeapObjectArgument(){

            @Override
            public int[] getIds(IProgressListener listener) throws SnapshotException {
                return HeapObjectContextArgument.this.getIds(listener);
            }

            @Override
            public Iterator<int[]> iterator() {
                return new Iterator<int[]>(){
                    Iterator<IContextObject> iter;
                    {
                        this.iter = (this).HeapObjectContextArgument.this.context.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public int[] next() {
                        IContextObject ctx = this.iter.next();
                        if (ctx instanceof IContextObjectSet) {
                            return ((IContextObjectSet)ctx).getObjectIds();
                        }
                        int objectId = ctx.getObjectId();
                        if (objectId >= 0) {
                            return new int[]{objectId};
                        }
                        return new int[0];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public String getLabel() {
                return HeapObjectContextArgument.this.label;
            }
        };
    }

    private int[] getIds(IProgressListener listener) {
        ArrayIntBig objIdxs = new ArrayIntBig();
        for (IContextObject ctx : this.context) {
            if (ctx instanceof IContextObjectSet) {
                objIdxs.addAll(((IContextObjectSet)ctx).getObjectIds());
            } else {
                int objectId = ctx.getObjectId();
                if (objectId >= 0) {
                    objIdxs.add(objectId);
                }
            }
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
        return objIdxs.toArray();
    }
}

