/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.emf.core;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.modisco.facet.util.core.DebugUtils;
import org.eclipse.modisco.facet.util.emf.core.exception.DebugRuntimeException;

public final class EmfDebugUtils {
    private EmfDebugUtils() {
    }

    public static String debugCommand(Command command) {
        return EmfDebugUtils.debugCommand(command, 1);
    }

    private static String debugCommand(Command command, int indent) {
        StringBuffer result = new StringBuffer();
        result.append('\n');
        int i = 0;
        while (i < indent) {
            result.append("--");
            ++i;
        }
        result.append(command.getClass().getSimpleName());
        result.append(" \"");
        result.append(command.getLabel());
        result.append("\" ");
        result.append(" canExecute=");
        result.append(command.canExecute());
        result.append(" (");
        result.append(command.getClass().getName());
        result.append(')');
        if (command instanceof CompoundCommand) {
            CompoundCommand compoundCommand = (CompoundCommand)command;
            for (Command subCommand : compoundCommand.getCommandList()) {
                result.append(EmfDebugUtils.debugCommand(subCommand, indent + 1));
            }
        }
        return result.toString();
    }

    public static String getStateDumpMessage(EObject eObject, String fileExtension) {
        File file = new File(String.valueOf(DebugUtils.getCallerLocation((int)1)) + '.' + fileExtension);
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)EcoreUtil.copy((EObject)eObject));
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new DebugRuntimeException(e);
        }
        return "A model containing the dumped EObject has been saved in " + file.getAbsolutePath();
    }
}

