/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class AbstractDataLocator {
    protected abstract IPath getSystemDataPath();

    protected abstract IPath getLocatorDataSegment();

    public final IPath getModelPath() {
        return this.getSystemDataPath().append(this.getLocatorDataSegment());
    }

    public IPath getFileScalingFragment(String fileName) {
        return new Path("");
    }

    public IPath getParentDir(String containerSegment, String typeFragment, String fileName) {
        IPath path = this.getModelPath();
        path = path.append(containerSegment);
        path = path.append(typeFragment);
        path = path.append(this.getFileScalingFragment(fileName));
        return path;
    }

    public IPath getFilePath(String containerSegment, String typeFragment, String itemName, String artifactExtension) {
        IPath path = this.getParentDir(containerSegment, typeFragment, itemName);
        path = path.append(itemName);
        path = path.addFileExtension(artifactExtension);
        return path;
    }

    public IPath getObjectPath(String containerSegment, String typeFragment, String itemName) {
        IPath path = new Path(containerSegment).makeAbsolute();
        path = path.append(typeFragment);
        path = path.append(itemName);
        return path;
    }

    public IPath getFilePathFromObjectPath(IPath path) {
        return this.getFilePath(path.segment(0), path.segment(1), path.removeFileExtension().lastSegment(), path.getFileExtension());
    }

    public IPath getObjectPathFromFilePath(IPath path) {
        if (this.getModelPath().isPrefixOf(path)) {
            String fragment = this.parseScalingFragment(path);
            path = path.makeRelativeTo(this.getModelPath());
            path = path.removeFileExtension();
            String cleanPath = StringUtils.remove((String)path.toPortableString(), (String)fragment);
            return new Path(cleanPath).makeAbsolute();
        }
        return path;
    }

    public IPath normalize(IPath path) {
        if (this.getModelPath().isPrefixOf(path)) {
            path = path.makeRelativeTo(this.getModelPath());
            return this.getFilePath(path.segment(0), path.segment(1), path.removeFileExtension().lastSegment(), path.getFileExtension());
        }
        return path;
    }

    public String parseFileType(IPath path) {
        return path.segment(path.segmentCount() - 2);
    }

    public String parseContainerSegment(IPath path) {
        if (this.getModelPath().isPrefixOf(path)) {
            path = path.makeRelativeTo(this.getModelPath());
        }
        return path.segment(0);
    }

    public String parseScalingFragment(IPath path) {
        path = path.makeRelativeTo(this.getModelPath());
        path = path.removeFirstSegments(2).removeFileExtension().removeLastSegments(1);
        return path.toString();
    }

    public String parseFileName(IPath path) {
        return path.removeFileExtension().lastSegment();
    }

    public void migrate() {
    }
}

