/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.uml.diagram.common.groups.core.groupcontainment.GroupContainmentRegistry;
import org.eclipse.papyrus.uml.diagram.common.groups.groupcontainment.AbstractContainerNodeDescriptor;

public class SetUpReferencesCommand
extends AbstractTransactionalCommand {
    private IAdaptable elementAdapter;
    private List<IGraphicalEditPart> graphicalParent;

    public SetUpReferencesCommand(TransactionalEditingDomain domain, String label, IAdaptable adapter, List<IGraphicalEditPart> _graphicalParents) {
        super(domain, label, null);
        this.elementAdapter = adapter;
        this.graphicalParent = _graphicalParents;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        Object createdElement = this.elementAdapter.getAdapter(EObject.class);
        if (createdElement instanceof EObject) {
            EObject eObjectCreatedElement = (EObject)createdElement;
            for (IGraphicalEditPart parent : this.graphicalParent) {
                EObject eObjectSourceReference = parent.resolveSemanticElement();
                AbstractContainerNodeDescriptor desc = GroupContainmentRegistry.getContainerDescriptor(parent);
                List<EReference> refs = desc.getReferenceFor(eObjectCreatedElement.eClass());
                for (EReference ref : refs) {
                    if (ref != null && ref.isMany()) {
                        Collection collection = (Collection)eObjectSourceReference.eGet((EStructuralFeature)ref);
                        if (collection.contains(eObjectCreatedElement)) continue;
                        collection.add(eObjectCreatedElement);
                        continue;
                    }
                    if (ref == null || ref.isMany()) continue;
                    eObjectSourceReference.eSet((EStructuralFeature)ref, (Object)eObjectCreatedElement);
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

