/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.validation.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.papyrus.infra.services.validation.internal.EValidatorAdapter;
import org.eclipse.papyrus.infra.services.validation.internal.EcoreDiagnostician;
import org.eclipse.papyrus.uml.service.validation.internal.OCLEValidatorAdapter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLDiagnostician
extends EcoreDiagnostician {
    protected boolean validateStereotype = false;

    public UMLDiagnostician() {
        super((EValidatorAdapter)new OCLEValidatorAdapter((EValidator)EValidator.Registry.INSTANCE.get((Object)UMLPackage.eINSTANCE)));
    }

    public UMLDiagnostician(EValidatorAdapter validatorAdapter) {
        super(validatorAdapter);
    }

    public Map<Object, Object> createDefaultContext() {
        Map context = super.createDefaultContext();
        if (context != null) {
            OCLDelegateDomain.initializePivotOnlyDiagnosticianContext((Map)context);
        }
        return context;
    }

    public BasicDiagnostic createDefaultDiagnostic(EObject eObject) {
        if (eObject == null || eObject.eResource() == null) {
            return super.createDefaultDiagnostic(eObject);
        }
        ResourceSet resourceSet = eObject.eResource().getResourceSet();
        if (resourceSet != null) {
            OCLDelegateDomain.initializePivotOnlyDiagnosticianResourceSet((ResourceSet)resourceSet);
        }
        return super.createDefaultDiagnostic(eObject);
    }

    protected boolean doValidateStereotypeApplications(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList stereotypeApplications;
        if (this.validateStereotype) {
            return true;
        }
        EList eList = stereotypeApplications = eObject instanceof Element ? ((Element)eObject).getStereotypeApplications() : Collections.emptyList();
        if (!stereotypeApplications.isEmpty()) {
            Iterator i = stereotypeApplications.iterator();
            this.validateStereotype = true;
            boolean result = this.validate((EObject)i.next(), diagnostics, context);
            while (i.hasNext() && (result || diagnostics != null)) {
                result &= this.validate((EObject)i.next(), diagnostics, context);
            }
            this.validateStereotype = false;
            return result;
        }
        return true;
    }

    protected boolean doValidateContents(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.doValidateStereotypeApplications(eObject, diagnostics, context);
        if (result || diagnostics != null) {
            result &= super.doValidateContents(eObject, diagnostics, context);
        }
        return result;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!context.containsKey((Object)this)) {
            context.put((Object)this, null);
            BasicDiagnostic newDiagChain = this.createDefaultDiagnostic(eObject);
            boolean ok = super.validate(eObject, (DiagnosticChain)newDiagChain, context);
            for (Diagnostic d : newDiagChain.getChildren()) {
                Element base;
                Object target;
                Object[] data = d.getData().toArray();
                if (data.length > 0 && (target = data[0]) instanceof EObject && (base = UMLUtil.getBaseElement((EObject)((EObject)target))) != null) {
                    data[0] = base;
                }
                diagnostics.add((Diagnostic)new BasicDiagnostic(d.getSeverity(), d.getSource(), d.getCode(), d.getMessage(), data));
            }
            return ok;
        }
        return super.validate(eObject, diagnostics, context);
    }
}

