/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.pde.api.tools.internal.FilterStore;
import org.eclipse.pde.api.tools.internal.IApiXmlConstants;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApiFilterStore
extends FilterStore
implements IResourceChangeListener {
    private HashMap<IResource, Set<IApiProblemFilter>> fUnusedFilters = null;
    IJavaProject fProject = null;
    boolean fNeedsSaving = false;
    boolean fTriggeredChange = false;
    HashMap<IResource, Map<String, Set<IApiProblemFilter>>> fFilterMap;

    public ApiFilterStore(IJavaProject project) {
        Assert.isNotNull((Object)project);
        this.fProject = project;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void persistApiFilters() {
        if (!this.fNeedsSaving) {
            return;
        }
        final LinkedHashMap<IResource, Map<String, Set<IApiProblemFilter>>> filters = new LinkedHashMap<IResource, Map<String, Set<IApiProblemFilter>>>(this.fFilterMap);
        WorkspaceJob job = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println("persisting api filters for plugin project component [" + ApiFilterStore.this.fProject.getElementName() + "]");
                }
                try {
                    InputStream xstream;
                    SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor);
                    IProject project = ApiFilterStore.this.fProject.getProject();
                    if (!project.isAccessible()) {
                        if (ApiPlugin.DEBUG_FILTER_STORE) {
                            System.out.println("project [" + ApiFilterStore.this.fProject.getElementName() + "] is not accessible, saving terminated");
                        }
                        return Status.CANCEL_STATUS;
                    }
                    String xml = ApiFilterStore.this.getStoreAsXml(filters);
                    IFile file = project.getFile(ApiFilterStore.this.getFilterFilePath(false));
                    if (xml == null) {
                        if (ApiPlugin.DEBUG_FILTER_STORE) {
                            System.out.println("no XML to persist for plugin project component [" + ApiFilterStore.this.fProject.getElementName() + "]");
                        }
                        if (file.isAccessible()) {
                            IFolder folder = (IFolder)file.getParent();
                            file.delete(true, (IProgressMonitor)localmonitor);
                            if (folder.members().length == 0 && folder.isAccessible()) {
                                folder.delete(true, (IProgressMonitor)localmonitor);
                            }
                            ApiFilterStore.this.fTriggeredChange = true;
                        }
                        return Status.OK_STATUS;
                    }
                    String lineDelimiter = ApiFilterStore.getLineDelimiterPreference(file);
                    if (lineDelimiter == null) {
                        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                        manager.connect(file.getFullPath(), LocationKind.IFILE, null);
                        ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
                        IDocument document = textFileBuffer.getDocument();
                        lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                    }
                    String lineSeparator = System.lineSeparator();
                    if (lineDelimiter != null && !lineDelimiter.equals(lineSeparator)) {
                        xml = xml.replaceAll(lineSeparator, lineDelimiter);
                    }
                    if ((xstream = Util.getInputStreamFromString(xml)) == null) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        if (file.getProject().isAccessible()) {
                            if (!file.exists()) {
                                IFolder folder = (IFolder)file.getParent();
                                if (!folder.exists()) {
                                    folder.create(true, true, (IProgressMonitor)localmonitor);
                                }
                                file.create(xstream, true, (IProgressMonitor)localmonitor);
                            } else {
                                file.setContents(xstream, true, false, (IProgressMonitor)localmonitor);
                            }
                        }
                    }
                    finally {
                        xstream.close();
                    }
                    ApiFilterStore.this.fTriggeredChange = true;
                    ApiFilterStore.this.fNeedsSaving = false;
                }
                catch (IOException | CoreException ioe) {
                    ApiPlugin.log(ioe);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    @Override
    public synchronized void addFilters(IApiProblemFilter[] filters) {
        if (filters == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("null filters array, not adding filters");
            }
            return;
        }
        this.initializeApiFilters();
        IApiProblemFilter[] iApiProblemFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IApiProblemFilter filter = iApiProblemFilterArray[n2];
            IApiProblem problem = filter.getUnderlyingProblem();
            String resourcePath = problem.getResourcePath();
            if (resourcePath != null && (resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath))) != null) {
                Map<String, Set<IApiProblemFilter>> pTypeNames = this.fFilterMap.get(resource);
                String typeName = problem.getTypeName();
                if (typeName == null) {
                    typeName = "!global!";
                }
                Set<IApiProblemFilter> pfilters = null;
                if (pTypeNames == null) {
                    pTypeNames = new HashMap<String, Set<IApiProblemFilter>>();
                    pfilters = new HashSet<IApiProblemFilter>();
                    pTypeNames.put(typeName, pfilters);
                    this.fFilterMap.put(resource, pTypeNames);
                } else {
                    pfilters = pTypeNames.get(typeName);
                    if (pfilters == null) {
                        pfilters = new HashSet<IApiProblemFilter>();
                        pTypeNames.put(typeName, pfilters);
                    }
                }
                this.fNeedsSaving |= pfilters.add(filter);
            }
            ++n2;
        }
        this.persistApiFilters();
    }

    @Override
    public synchronized void addFiltersFor(IApiProblem[] problems) {
        if (problems == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("null problems array: not addding filters");
            }
            return;
        }
        if (problems.length < 1) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("empty problem array: not addding filters");
            }
            return;
        }
        this.initializeApiFilters();
        this.internalAddFilters(problems, null);
        this.persistApiFilters();
    }

    @Override
    public synchronized IApiProblemFilter[] getFilters(IResource resource) {
        this.initializeApiFilters();
        Map<String, Set<IApiProblemFilter>> pTypeNames = this.fFilterMap.get(resource);
        if (pTypeNames == null) {
            return FilterStore.NO_FILTERS;
        }
        ArrayList<IApiProblemFilter> allFilters = new ArrayList<IApiProblemFilter>();
        for (Set<IApiProblemFilter> values : pTypeNames.values()) {
            allFilters.addAll(values);
        }
        return allFilters.toArray(new IApiProblemFilter[allFilters.size()]);
    }

    @Override
    public synchronized boolean isFiltered(IApiProblem problem) {
        this.initializeApiFilters();
        String resourcePath = problem.getResourcePath();
        if (resourcePath == null) {
            return false;
        }
        IResource resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath));
        if (resource == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("no resource exists: [" + resourcePath + "]");
            }
            return false;
        }
        IApiProblemFilter[] filters = this.getFilters(resource);
        if (filters == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("no filters defined for [" + resourcePath + "] return not filtered");
            }
            return false;
        }
        IApiProblemFilter[] iApiProblemFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IApiProblemFilter filter = iApiProblemFilterArray[n2];
            if (this.problemsMatch(filter.getUnderlyingProblem(), problem)) {
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println("recording filter used: [" + filter.toString() + "]");
                }
                this.recordFilterUsed(resource, filter);
                return true;
            }
            ++n2;
        }
        if (ApiPlugin.DEBUG_FILTER_STORE) {
            System.out.println("no filter defined for problem: [" + problem.toString() + "]");
        }
        return false;
    }

    @Override
    public void dispose() {
        this.persistApiFilters();
        this.clearFilters();
        if (this.fUnusedFilters != null) {
            this.fUnusedFilters.clear();
            this.fUnusedFilters = null;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public synchronized IResource[] getResources() {
        this.initializeApiFilters();
        Set<IResource> resources = this.fFilterMap.keySet();
        return resources.toArray(new IResource[resources.size()]);
    }

    @Override
    public synchronized boolean removeFilters(IApiProblemFilter[] filters) {
        if (filters == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("null filters array, not removing");
            }
            return false;
        }
        if (this.fFilterMap == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("null filter map, not removing");
            }
            return false;
        }
        boolean success = true;
        IApiProblemFilter[] iApiProblemFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IApiProblemFilter filter = iApiProblemFilterArray[n2];
            IApiProblem underlyingProblem = filter.getUnderlyingProblem();
            String resourcePath = underlyingProblem.getResourcePath();
            if (resourcePath != null) {
                Map<String, Set<IApiProblemFilter>> pTypeNames;
                IResource resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath));
                if (resource == null) {
                    resource = this.fProject.getProject().getFile(resourcePath);
                }
                if ((pTypeNames = this.fFilterMap.get(resource)) != null) {
                    Set<IApiProblemFilter> pfilters;
                    String typeName = underlyingProblem.getTypeName();
                    if (typeName == null) {
                        typeName = "!global!";
                    }
                    if ((pfilters = pTypeNames.get(typeName)) != null && pfilters.remove(filter)) {
                        if (ApiPlugin.DEBUG_FILTER_STORE) {
                            System.out.println("removed filter: [" + filter + "]");
                        }
                        this.fNeedsSaving |= true;
                        success &= true;
                        if (pfilters.isEmpty()) {
                            pTypeNames.remove(typeName);
                            if (pTypeNames.isEmpty()) {
                                success &= this.fFilterMap.remove(resource) != null;
                            }
                        }
                    } else {
                        success &= false;
                    }
                }
            }
            ++n2;
        }
        this.persistApiFilters();
        return success;
    }

    synchronized String getStoreAsXml(Map<IResource, Map<String, Set<IApiProblemFilter>>> filtermap) throws CoreException {
        if (filtermap == null) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("no filter map returning null XML for project [" + this.fProject.getElementName() + "]");
            }
            return null;
        }
        if (filtermap.isEmpty()) {
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("empty filter map returning null XML for project [" + this.fProject.getElementName() + "]");
            }
            return null;
        }
        Document document = Util.newDocument();
        Element root = document.createElement("component");
        document.appendChild(root);
        root.setAttribute("id", this.fProject.getElementName());
        root.setAttribute("version", IApiXmlConstants.API_FILTER_STORE_CURRENT_VERSION);
        Set<Map.Entry<IResource, Map<String, Set<IApiProblemFilter>>>> allFiltersEntrySet = filtermap.entrySet();
        ArrayList<Map.Entry<IResource, Map<String, Set<IApiProblemFilter>>>> allFiltersEntries = new ArrayList<Map.Entry<IResource, Map<String, Set<IApiProblemFilter>>>>(allFiltersEntrySet.size());
        allFiltersEntries.addAll(allFiltersEntrySet);
        Collections.sort(allFiltersEntries, (o1, o2) -> {
            Map.Entry entry1 = o1;
            Map.Entry entry2 = o2;
            String path1 = ((IResource)entry1.getKey()).getFullPath().toOSString();
            String path2 = ((IResource)entry2.getKey()).getFullPath().toOSString();
            return path1.compareTo(path2);
        });
        for (Map.Entry entry : allFiltersEntries) {
            IResource resource = (IResource)entry.getKey();
            Map pTypeNames = (Map)entry.getValue();
            if (pTypeNames == null) continue;
            Set allTypeNamesEntriesSet = pTypeNames.entrySet();
            ArrayList allTypeNamesEntries = new ArrayList(allTypeNamesEntriesSet.size());
            allTypeNamesEntries.addAll(allTypeNamesEntriesSet);
            Collections.sort(allTypeNamesEntries, (o1, o2) -> {
                Map.Entry entry1 = o1;
                Map.Entry entry2 = o2;
                String typeName1 = (String)entry1.getKey();
                String typeName2 = (String)entry2.getKey();
                return typeName1.compareTo(typeName2);
            });
            for (Map.Entry entry2 : allTypeNamesEntries) {
                String typeName = (String)entry2.getKey();
                Set filters = (Set)entry2.getValue();
                if (filters.isEmpty()) continue;
                Element relement = document.createElement("resource");
                relement.setAttribute("path", resource.getProjectRelativePath().toPortableString());
                boolean typeNameIsInitialized = false;
                if (typeName != "!global!") {
                    relement.setAttribute("type", typeName);
                    typeNameIsInitialized = true;
                }
                root.appendChild(relement);
                typeName = null;
                ArrayList filtersList = new ArrayList(filters.size());
                filtersList.addAll(filters);
                Collections.sort(filtersList, (o1, o2) -> {
                    int problem2Id;
                    IApiProblem p1 = o1.getUnderlyingProblem();
                    IApiProblem p2 = o2.getUnderlyingProblem();
                    int problem1Id = p1.getId();
                    int ids = problem1Id - (problem2Id = p2.getId());
                    if (ids == 0) {
                        String[] args2;
                        String[] args1 = p1.getMessageArguments();
                        int length = args1.length < (args2 = p2.getMessageArguments()).length ? args1.length : args2.length;
                        int i = 0;
                        while (i < length) {
                            int args = args1[i].compareTo(args2[i]);
                            if (args != 0) {
                                return args;
                            }
                            ++i;
                        }
                        return args1.length - args2.length;
                    }
                    return ids;
                });
                for (IApiProblemFilter filter : filtersList) {
                    String[] messageArguments;
                    int length;
                    IApiProblem problem = filter.getUnderlyingProblem();
                    typeName = problem.getTypeName();
                    Element filterElement = document.createElement("filter");
                    filterElement.setAttribute("id", Integer.toString(problem.getId()));
                    String comment = filter.getComment();
                    if (comment != null) {
                        filterElement.setAttribute("comment", comment);
                    }
                    if ((length = (messageArguments = problem.getMessageArguments()).length) > 0) {
                        Element messageArgumentsElement = document.createElement("message_arguments");
                        int j = 0;
                        while (j < length) {
                            Element messageArgumentElement = document.createElement("message_argument");
                            messageArgumentElement.setAttribute("value", String.valueOf(messageArguments[j]));
                            messageArgumentsElement.appendChild(messageArgumentElement);
                            ++j;
                        }
                        filterElement.appendChild(messageArgumentsElement);
                    }
                    relement.appendChild(filterElement);
                }
                if (typeName == null || typeNameIsInitialized || typeName.length() == 0) continue;
                relement.setAttribute("type", typeName);
            }
        }
        return Util.serializeDocument(document);
    }

    @Override
    protected synchronized void initializeApiFilters() {
        block19: {
            if (this.fFilterMap != null) {
                return;
            }
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("initializing api filter map for project [" + this.fProject.getElementName() + "]");
            }
            this.fFilterMap = new LinkedHashMap<IResource, Map<String, Set<IApiProblemFilter>>>(5);
            IPath filepath = this.getFilterFilePath(true);
            IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(filepath, true);
            if (file == null) {
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println(".api_filter file not found during initialization for project [" + this.fProject.getElementName() + "]");
                }
                return;
            }
            InputStream contents = null;
            try {
                try {
                    IFile filterFile = (IFile)file;
                    if (filterFile.exists()) {
                        contents = filterFile.getContents();
                        this.readFilterFile(contents);
                    }
                }
                catch (IOException | CoreException e) {
                    ApiPlugin.log(e);
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.fNeedsSaving = false;
    }

    @Override
    protected synchronized void internalAddFilters(IApiProblem[] problems, String[] comments) {
        Set<Object> filters = null;
        int i = 0;
        while (i < problems.length) {
            IResource resource;
            IApiProblem problem = problems[i];
            ApiProblemFilter filter = new ApiProblemFilter(this.fProject.getElementName(), problem, comments == null ? null : comments[i]);
            String resourcePath = problem.getResourcePath();
            if (resourcePath != null && (resource = this.fProject.getProject().findMember((IPath)new Path(resourcePath))) != null) {
                Map<String, Set<IApiProblemFilter>> pTypeNames = this.fFilterMap.get(resource);
                String typeName = problem.getTypeName();
                if (typeName == null) {
                    typeName = "!global!";
                }
                if (pTypeNames == null) {
                    filters = new LinkedHashSet();
                    pTypeNames = new LinkedHashMap<String, Set<IApiProblemFilter>>();
                    pTypeNames.put(typeName, filters);
                    this.fFilterMap.put(resource, pTypeNames);
                } else {
                    filters = pTypeNames.get(typeName);
                    if (filters == null) {
                        filters = new LinkedHashSet();
                        pTypeNames.put(typeName, filters);
                    }
                }
                this.fNeedsSaving |= filters.add(filter);
            }
            ++i;
        }
    }

    public void needsSaving() {
        this.fNeedsSaving = true;
    }

    IPath getFilterFilePath(boolean includeproject) {
        if (includeproject) {
            IPath path = this.fProject.getPath();
            return path.append(".settings").append(".api_filters");
        }
        return new Path(".settings").append(".api_filters");
    }

    static String getLineDelimiterPreference(IFile file) {
        IScopeContext[] scopeContext;
        if (file != null && file.getProject() != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(file.getProject())};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
    }

    public synchronized void recordFilterUsage() {
        this.initializeApiFilters();
        this.fUnusedFilters = new LinkedHashMap<IResource, Set<IApiProblemFilter>>();
        Map<String, Set<IApiProblemFilter>> types = null;
        LinkedHashSet values = null;
        for (Map.Entry<IResource, Map<String, Set<IApiProblemFilter>>> filterEntry : this.fFilterMap.entrySet()) {
            IResource resource = filterEntry.getKey();
            types = filterEntry.getValue();
            values = new LinkedHashSet();
            this.fUnusedFilters.put(resource, values);
            for (Map.Entry<String, Set<IApiProblemFilter>> entry : types.entrySet()) {
                values.addAll(entry.getValue());
            }
        }
    }

    private void recordFilterUsed(IResource resource, IApiProblemFilter filter) {
        Set<IApiProblemFilter> unused;
        if (this.fUnusedFilters != null && (unused = this.fUnusedFilters.get(resource)) != null) {
            unused.remove(filter);
            if (unused.isEmpty()) {
                this.fUnusedFilters.remove(resource);
            }
        }
    }

    public IApiProblemFilter[] getUnusedFilters(IResource resource, String typeName, int[] categories) {
        if (this.fUnusedFilters != null) {
            int size;
            HashSet<IApiProblemFilter> unused = new HashSet<IApiProblemFilter>();
            Set<IApiProblemFilter> set = null;
            if (resource != null) {
                set = this.fUnusedFilters.get(resource);
                if (set != null) {
                    this.collectFilterFor(set, typeName, unused, categories);
                }
                if (Util.isManifest(resource.getProjectRelativePath())) {
                    IResource res = null;
                    for (Map.Entry<IResource, Set<IApiProblemFilter>> entry : this.fUnusedFilters.entrySet()) {
                        res = entry.getKey();
                        if (res == null || !res.exists() || !res.getProject().equals((Object)resource.getProject())) continue;
                        set = this.fUnusedFilters.get(res);
                        this.collectFilterFor(set, typeName, unused, categories);
                    }
                }
            } else {
                for (Map.Entry<IResource, Set<IApiProblemFilter>> entry : this.fUnusedFilters.entrySet()) {
                    set = entry.getValue();
                    if (set == null) continue;
                    unused.addAll(set);
                }
            }
            if ((size = unused.size()) == 0) {
                return FilterStore.NO_FILTERS;
            }
            return unused.toArray(new IApiProblemFilter[size]);
        }
        return FilterStore.NO_FILTERS;
    }

    private void collectFilterFor(Set<IApiProblemFilter> filters, String typename, Set<IApiProblemFilter> collector, int[] categories) {
        for (IApiProblemFilter filter : filters) {
            String underlyingTypeName;
            IApiProblem underlyingProblem = filter.getUnderlyingProblem();
            if (underlyingProblem == null || this.matchesCategory(underlyingProblem, categories) || (underlyingTypeName = underlyingProblem.getTypeName()) == null || typename != null && !underlyingTypeName.equals(typename)) continue;
            collector.add(filter);
        }
    }

    private boolean matchesCategory(IApiProblem problem, int[] categories) {
        if (categories != null) {
            int cat = problem.getCategory();
            int[] nArray = categories;
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                int categorie = nArray[n2];
                if (cat == categorie) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public String toString() {
        return "API filter store for component: " + this.fProject.getElementName();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fTriggeredChange) {
            this.fTriggeredChange = false;
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("ignoring triggered change");
            }
            return;
        }
        if (event.getType() == 1) {
            IPath path = this.getFilterFilePath(true);
            IResourceDelta leafdelta = event.getDelta().findMember(path);
            if (leafdelta == null) {
                return;
            }
            boolean needsbuild = false;
            if (leafdelta.getKind() == 2) {
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println("processed REMOVED delta");
                }
                if (this.fFilterMap != null) {
                    this.fFilterMap.clear();
                    needsbuild = this.fProject.getProject().isAccessible();
                }
            } else if (leafdelta.getKind() == 1 || (leafdelta.getFlags() & 0x100) != 0 || (leafdelta.getFlags() & 0x40000) != 0) {
                IResource resource;
                if (ApiPlugin.DEBUG_FILTER_STORE) {
                    System.out.println("processing ADDED or CONTENT or REPLACED");
                }
                if ((resource = leafdelta.getResource()) != null && resource.getType() == 1) {
                    IFile file;
                    if (ApiPlugin.DEBUG_FILTER_STORE) {
                        System.out.println("processed FILE delta for [" + resource.getName() + "]");
                    }
                    if ((file = (IFile)resource).isAccessible()) {
                        try {
                            this.clearFilters();
                            this.initializeApiFilters();
                        }
                        finally {
                            needsbuild = this.fProject.getProject().isAccessible();
                        }
                    }
                }
            }
            if (needsbuild && !ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                Util.getBuildJob(new IProject[]{this.fProject.getProject()}, 10).schedule();
            }
        }
    }

    private synchronized void clearFilters() {
        if (this.fFilterMap != null) {
            this.fFilterMap.clear();
            this.fFilterMap = null;
        }
    }
}

