/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.search.MethodNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.internal.core.search.DLTKSearchMethodNameMatch;
import org.eclipse.dltk.internal.core.search.DLTKSearchTypeNameMatch;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.search.FieldNameMatch;
import org.eclipse.php.internal.core.search.IElementNameMatch;
import org.eclipse.php.internal.core.search.PHPSearchMethodNameMatch;
import org.eclipse.php.internal.core.search.PHPSearchTypeNameMatch;
import org.eclipse.php.internal.ui.PHPUILanguageToolkit;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class PHPElementNameMatchLabelProvider
extends LabelProvider {
    public static final int SHOW_FULLYQUALIFIED = 1;
    public static final int SHOW_PACKAGE_POSTFIX = 2;
    public static final int SHOW_PACKAGE_ONLY = 4;
    public static final int SHOW_ROOT_POSTFIX = 8;
    public static final int SHOW_TYPE_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    public static final int SHOW_POST_QUALIFIED = 64;
    private static final Image PHPFOLDER_ICON = PHPPluginImages.get("org.eclipse.php.ui.folderroot_obj.png");
    private static final Image NAMESPACE_ICON = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.namespace_obj.png");
    private static final Image CLASS_ICON = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.class_obj.png");
    private static final Image INTERFACE_ICON = PHPPluginImages.get("org.eclipse.php.ui.phpinterfacedata.png");
    private static final Image TRAIT_ICON = PHPPluginImages.get("org.eclipse.php.ui.trait_obj.png");
    private static final Image METHOD_ICON = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.methpub_obj.png");
    private static final Image FIELD_ICON = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.field_public_obj.png");
    private static final Image CONSTANT_ICON = PHPUiPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new PHPElementImageDescriptor(PHPPluginImages.DESC_CONSTANT, 2, ScriptElementImageProvider.SMALL_SIZE));
    private final int fFlags;

    public PHPElementNameMatchLabelProvider(int flags) {
        this.fFlags = flags;
    }

    public String getText(Object element) {
        String packName;
        String containerName;
        if (!((element = this.convert(element)) instanceof IElementNameMatch)) {
            return super.getText(element);
        }
        IElementNameMatch elementRef = (IElementNameMatch)element;
        StringBuilder buf = new StringBuilder();
        if (this.isSet(16)) {
            buf.append(elementRef.getSimpleName());
        } else if (this.isSet(32)) {
            containerName = elementRef.getContainerName();
            buf.append(this.getPackageName(containerName));
        } else if (this.isSet(4)) {
            packName = elementRef.getPackageName();
            buf.append(this.getPackageName(packName));
        } else {
            if (this.isSet(1)) {
                buf.append(elementRef.getFullyQualifiedName());
            } else if (this.isSet(64)) {
                buf.append(elementRef.getSimpleName());
                containerName = elementRef.getContainerName();
                if (containerName != null && containerName.length() > 0) {
                    buf.append(" - ");
                    buf.append(containerName);
                }
            } else {
                buf.append(elementRef.getTypeQualifiedName());
            }
            if (this.isSet(2)) {
                buf.append(" - ");
                packName = elementRef.getPackageName();
                buf.append(this.getPackageName(packName));
            }
        }
        if (this.isSet(8)) {
            buf.append(" - ");
            IProjectFragment root = elementRef.getProjectFragment();
            ScriptElementLabels labels = PHPUILanguageToolkit.getInstance().getScriptElementLabels();
            StringBuffer sb = new StringBuffer();
            labels.getProjectFragmentLabel(root, 0x20000000000L, sb);
            buf.append(sb);
        }
        return buf.toString();
    }

    private String getPackageName(String packName) {
        if (packName.length() == 0) {
            return DLTKUIMessages.TypeInfoLabelProvider_default_package;
        }
        return packName;
    }

    public Image getImage(Object element) {
        if (!((element = this.convert(element)) instanceof IElementNameMatch)) {
            return super.getImage(element);
        }
        if (this.isSet(32)) {
            IElementNameMatch typeRef = (IElementNameMatch)element;
            if (typeRef.getPackageName().equals(typeRef.getContainerName())) {
                return PHPFOLDER_ICON;
            }
            return NAMESPACE_ICON;
        }
        if (this.isSet(4)) {
            return PHPFOLDER_ICON;
        }
        if (element instanceof TypeNameMatch) {
            int modifiers = ((TypeNameMatch)element).getModifiers();
            if (Flags.isInterface((int)modifiers)) {
                return INTERFACE_ICON;
            }
            if (PHPFlags.isTrait((int)modifiers)) {
                return TRAIT_ICON;
            }
            return CLASS_ICON;
        }
        if (element instanceof MethodNameMatch) {
            return METHOD_ICON;
        }
        if (element instanceof FieldNameMatch) {
            int modifiers = ((FieldNameMatch)element).getModifiers();
            if (PHPFlags.isConstant((int)modifiers)) {
                return CONSTANT_ICON;
            }
            return FIELD_ICON;
        }
        return super.getImage(element);
    }

    private boolean isSet(int flag) {
        return (this.fFlags & flag) != 0;
    }

    private Object convert(Object element) {
        if (element.getClass() == DLTKSearchTypeNameMatch.class) {
            DLTKSearchTypeNameMatch nameMatch = (DLTKSearchTypeNameMatch)element;
            return new PHPSearchTypeNameMatch(nameMatch.getType(), nameMatch.getModifiers());
        }
        if (element.getClass() == DLTKSearchMethodNameMatch.class) {
            DLTKSearchMethodNameMatch nameMatch = (DLTKSearchMethodNameMatch)element;
            return new PHPSearchMethodNameMatch(nameMatch.getMethod(), nameMatch.getModifiers());
        }
        return element;
    }
}

