/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.ptp.core.util.ArgumentParser;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJob;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStatus;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStreamsProxy;
import org.eclipse.ptp.internal.rm.jaxb.control.core.IStreamParserTokenizer;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlConstants;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;
import org.eclipse.ptp.internal.rm.jaxb.control.core.LaunchController;
import org.eclipse.ptp.internal.rm.jaxb.control.core.RemoteServicesDelegate;
import org.eclipse.ptp.internal.rm.jaxb.control.core.data.ArgImpl;
import org.eclipse.ptp.internal.rm.jaxb.control.core.messages.Messages;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command.CommandJobStatus;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command.CommandJobStreamMonitor;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command.CommandJobStreamsProxy;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command.ConfigurableRegexTokenizer;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command.SimpleCommandJob;
import org.eclipse.ptp.internal.rm.jaxb.control.core.utils.DebuggingLogger;
import org.eclipse.ptp.internal.rm.jaxb.control.core.utils.EnvironmentVariableUtils;
import org.eclipse.ptp.internal.rm.jaxb.core.JAXBCoreConstants;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.CommandType;
import org.eclipse.ptp.rm.jaxb.core.data.EnvironmentType;
import org.eclipse.ptp.rm.jaxb.core.data.SimpleCommandType;
import org.eclipse.ptp.rm.jaxb.core.data.TokenizerType;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.ui.progress.IProgressConstants;

public class CommandJob
extends Job
implements ICommandJob {
    private final String uuid;
    private final CommandType command;
    private final ILaunchController control;
    private final ICommandJobStreamsProxy proxy;
    private final IVariableMap rmVarMap;
    private final JobMode jobMode;
    private final ILaunchConfiguration launchConfig;
    private final String launchMode;
    private final List<SimpleCommandJob> cmdJobs = new ArrayList<SimpleCommandJob>();
    private final StringBuffer error;
    private IStatus runStatus;
    private Thread jobThread;
    private IRemoteProcess process;
    private IStreamParserTokenizer stdoutTokenizer;
    private IStreamParserTokenizer stderrTokenizer;
    private Thread stdoutT;
    private Thread stderrT;
    private InputStream tokenizerOut;
    private InputStream tokenizerErr;
    private StreamSplitter outSplitter;
    private StreamSplitter errSplitter;
    private IStreamMonitor[] batchMonitors;
    private ICommandJobStatus jobStatus;
    private boolean active;

    public static IStreamParserTokenizer getTokenizer(String type) throws CoreException {
        IConfigurationElement[] elements;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rm.jaxb.control.core", "streamParserTokenizer");
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(type)) {
                return (IStreamParserTokenizer)element.createExecutableExtension("class");
            }
            ++n2;
        }
        return null;
    }

    public CommandJob(String jobUUID, CommandType command, JobMode jobMode, ILaunchController control, IVariableMap map, ILaunchConfiguration launchConfig, String launchMode) {
        super(String.valueOf(command.getName()) + ":" + " " + (jobUUID == null ? control.getConnectionName() : jobUUID));
        this.command = command;
        this.jobMode = jobMode;
        this.launchConfig = launchConfig;
        this.launchMode = launchMode;
        this.control = control;
        this.rmVarMap = map;
        this.uuid = jobUUID;
        this.proxy = new CommandJobStreamsProxy();
        this.error = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus execute(IProgressMonitor monitor) {
        CommandJob commandJob;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            commandJob = this;
            synchronized (commandJob) {
                this.active = false;
            }
            IRemoteProcessBuilder builder = this.prepareCommand((IProgressMonitor)progress.newChild(10));
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.prepareEnv(builder);
            progress.worked(10);
            this.process = null;
            try {
                this.process = builder.start(this.getFlags(this.command.getFlags()));
            }
            catch (IOException t) {
                return CoreExceptionUtils.getErrorStatus((String)(String.valueOf(Messages.CouldNotLaunch) + builder), (Throwable)t);
            }
            progress.worked(30);
            this.maybeInitializeTokenizers(builder);
            this.setOutStreamRedirection(this.process);
            this.setErrStreamRedirection(this.process);
            this.startConsumers();
            CommandJob t = this;
            synchronized (t) {
                this.active = true;
            }
            progress.worked(20);
            int exit = 0;
            if (this.uuid != null) {
                if (!this.command.isWaitForId()) {
                    if (this.process.isCompleted()) {
                        exit = this.process.exitValue();
                    }
                    if (exit != 0) {
                        return this.processError((String)builder.command().get(0), exit, null);
                    }
                    return Status.OK_STATUS;
                }
                if (this.command.isKeepOpen()) {
                    return Status.OK_STATUS;
                }
            }
            try {
                exit = this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IStatus status = this.joinConsumers();
            if (exit != 0) {
                return this.processError((String)builder.command().get(0), exit, status);
            }
            if (!status.isOK()) {
                return status;
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        commandJob = this;
        synchronized (commandJob) {
            this.active = false;
        }
        return Status.OK_STATUS;
    }

    private Object getAttributeValue(IVariableMap vars, String name) {
        AttributeType attr = vars.get(name);
        if (attr != null) {
            Object linkVal;
            String link = attr.getLinkValueTo();
            if (link != null && (linkVal = this.getAttributeValue(vars, link)) != null) {
                return linkVal;
            }
            return attr.getValue();
        }
        return null;
    }

    public int getFlags(String flags) {
        if (flags == null) {
            return 0;
        }
        String[] split = flags.split("[|]");
        int f = 0;
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ("ALLOCATE_PTY".equals(s = s.trim())) {
                f |= 1;
            } else if ("FORWARD_X11".equals(s)) {
                f |= 2;
            }
            ++n2;
        }
        return f;
    }

    @Override
    public ICommandJobStatus getJobStatus() {
        return this.jobStatus;
    }

    @Override
    public IRemoteProcess getProcess() {
        return this.process;
    }

    @Override
    public ICommandJobStreamsProxy getProxy() {
        return this.proxy;
    }

    @Override
    public IStatus getRunStatus() {
        return this.runStatus;
    }

    private boolean hasInput() {
        return !this.command.getInput().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        boolean b = false;
        CommandJob commandJob = this;
        synchronized (commandJob) {
            b = this.active;
        }
        return b;
    }

    @Override
    public boolean isBatch() {
        return this.jobMode == JobMode.BATCH;
    }

    @Override
    public IStatus joinConsumers() {
        IStatus status = Status.OK_STATUS;
        if (this.isActive()) {
            if (this.outSplitter != null) {
                try {
                    this.outSplitter.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.errSplitter != null) {
                try {
                    this.errSplitter.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.stdoutT != null) {
                try {
                    this.stdoutT.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                status = this.stdoutTokenizer.getStatus();
            }
            if (this.stderrT != null) {
                try {
                    this.stderrT.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (status.isOK()) {
                    status = this.stderrTokenizer.getStatus();
                }
            }
        }
        return status;
    }

    private void maybeInitializeTokenizers(IRemoteProcessBuilder builder) throws CoreException {
        String type;
        TokenizerType t = null;
        if (builder.redirectErrorStream()) {
            t = this.command.getRedirectParser();
        }
        if (t == null) {
            t = this.command.getStdoutParser();
        }
        if (t != null) {
            type = t.getType();
            if (type != null) {
                try {
                    this.stdoutTokenizer = CommandJob.getTokenizer(type);
                }
                catch (Throwable e) {
                    throw CoreExceptionUtils.newException((String)Messages.StreamTokenizerInstantiationError, (Throwable)e);
                }
            } else {
                this.stdoutTokenizer = new ConfigurableRegexTokenizer(t);
            }
            this.stdoutTokenizer.initialize(this.uuid, this.rmVarMap);
        }
        if ((t = this.command.getStderrParser()) != null) {
            type = t.getType();
            if (type != null) {
                try {
                    this.stderrTokenizer = CommandJob.getTokenizer(type);
                }
                catch (Throwable e) {
                    throw CoreExceptionUtils.newException((String)Messages.StreamTokenizerInstantiationError, (Throwable)e);
                }
            } else {
                this.stderrTokenizer = new ConfigurableRegexTokenizer(t);
            }
            this.stderrTokenizer.initialize(this.uuid, this.rmVarMap);
        }
    }

    private IRemoteProcessBuilder prepareCommand(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        List args = this.command.getArg();
        if (args == null) {
            throw CoreExceptionUtils.newException((String)Messages.MissingArglistFromCommandError, null);
        }
        ArgumentParser cmdArgs = new ArgumentParser(ArgImpl.getArgs(this.uuid, args, this.rmVarMap));
        RemoteServicesDelegate delegate = RemoteServicesDelegate.getDelegate(this.control.getRemoteServicesId(), this.control.getConnectionName(), (IProgressMonitor)progress.newChild(5));
        if (progress.isCanceled()) {
            return null;
        }
        if (delegate.getRemoteConnection() == null) {
            throw CoreExceptionUtils.newException((String)Messages.MissingArglistFromCommandError, (Throwable)new Throwable(Messages.UninitializedRemoteServices));
        }
        IRemoteConnection conn = delegate.getRemoteConnection();
        LaunchController.checkConnection(conn, progress.newChild(5));
        if (progress.isCanceled()) {
            return null;
        }
        if (DebuggingLogger.getLogger().getCommand()) {
            System.out.println(String.valueOf(this.getName()) + ": " + cmdArgs.getCommandLine(false));
        }
        IRemoteProcessBuilder builder = delegate.getRemoteProcessBuilder(cmdArgs.getTokenList());
        String directory = this.command.getDirectory();
        if (directory != null && !"".equals(directory)) {
            directory = this.rmVarMap.getString(this.uuid, directory);
            IFileStore dir = delegate.getRemoteFileService().getResource(directory);
            builder.directory(dir);
        }
        return builder;
    }

    public void prepareEnv(IRemoteProcessBuilder builder) throws CoreException {
        boolean appendEnv = true;
        HashMap launchEnv = new HashMap();
        if (this.launchConfig != null) {
            appendEnv = this.launchConfig.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            Map map = this.launchConfig.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            if (map != null) {
                launchEnv.putAll(map);
            }
        }
        if (!appendEnv) {
            builder.environment().clear();
            for (String var : launchEnv.keySet()) {
                builder.environment().put(var, (String)launchEnv.get(var));
            }
        } else {
            List vars = this.command.getEnvironment();
            if (this.command.isReplaceEnvironment()) {
                HashMap<String, String> savedVars = new HashMap<String, String>();
                for (EnvironmentType var : vars) {
                    if (!var.isPreserve().booleanValue()) continue;
                    savedVars.put(var.getName(), (String)builder.environment().get(var.getName()));
                }
                builder.environment().clear();
                builder.environment().putAll(savedVars);
            }
            for (Object var : vars) {
                EnvironmentVariableUtils.addVariable(this.uuid, var, builder.environment(), this.rmVarMap);
            }
            for (Object var : launchEnv.keySet()) {
                builder.environment().put(var, (String)launchEnv.get(var));
            }
        }
        builder.redirectErrorStream(this.command.isRedirectStderr());
    }

    private String prepareInput() throws CoreException {
        List args = this.command.getInput();
        return ArgImpl.toString(this.uuid, args, this.rmVarMap);
    }

    private IStatus processError(String arg, int exit, IStatus status) throws CoreException {
        if (status != null && !status.isOK()) {
            this.error.append(status.getMessage()).append(JAXBControlConstants.LINE_SEP);
        }
        String message = this.error.toString();
        this.error.setLength(0);
        return CoreExceptionUtils.getErrorStatus((String)(String.valueOf(arg) + " " + Messages.ProcessExitValueError + Integer.toString(exit) + JAXBControlConstants.LINE_SEP + message), null);
    }

    @Override
    public void rerun() {
        if (this.hasInput() && this.isActive() && this.jobStatus.getState().equals("RUNNING")) {
            if (this.process != null && !this.process.isCompleted() && !this.launchMode.equals("debug")) {
                this.writeInputToProcess(this.process);
            } else {
                this.terminate();
            }
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        CommandJob parent;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.jobThread = Thread.currentThread();
        for (SimpleCommandType cmd : this.command.getPreLaunchCmd()) {
            SimpleCommandJob job = new SimpleCommandJob(this.uuid, cmd, this.command.getDirectory(), this.control, this.rmVarMap, this);
            job.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
            job.schedule();
            if (cmd.isWait()) {
                try {
                    job.join();
                    if (cmd.isIgnoreExitStatus() || job.getResult().isOK()) continue;
                    return job.getResult();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.cmdJobs.add(job);
        }
        this.runStatus = this.execute((IProgressMonitor)progress.newChild(50));
        if (!this.runStatus.isOK()) {
            return this.runStatus;
        }
        if (this.uuid == null) {
            return Status.OK_STATUS;
        }
        this.jobStatus = null;
        String waitUntil = this.command.isKeepOpen() ? "RUNNING" : "SUBMITTED";
        CommandJob commandJob = parent = this.command.isKeepOpen() ? this : null;
        if (this.command.isWaitForId()) {
            this.jobStatus = new CommandJobStatus(parent, this.control, this.rmVarMap, this.launchMode);
            this.jobStatus.setOwner(this.rmVarMap.getString("${ptp_rm:control.user.name#value}"));
            this.jobStatus.setQueueName(this.rmVarMap.getString("${ptp_rm:control.queue.name#value}"));
            if (!this.isBatch()) {
                this.jobStatus.setProcess(this.process);
            }
            this.jobStatus.setProxy(this.getProxy());
            try {
                this.jobStatus.waitForJobId(this.uuid, waitUntil, (IProgressMonitor)progress.newChild(20));
            }
            catch (CoreException failed) {
                this.terminate();
                this.error.append(this.jobStatus.getStreamsProxy().getOutputStreamMonitor().getContents()).append(JAXBCoreConstants.LINE_SEP);
                this.runStatus = CoreExceptionUtils.getErrorStatus((String)(String.valueOf(failed.getMessage()) + JAXBCoreConstants.LINE_SEP + this.error.toString()), null);
                this.error.setLength(0);
                return Status.OK_STATUS;
            }
        } else {
            AttributeType a;
            String state;
            if (!this.command.isKeepOpen()) {
                this.runStatus = this.joinConsumers();
                if (!this.runStatus.isOK()) {
                    return Status.OK_STATUS;
                }
            }
            if ((state = (String)(a = this.rmVarMap.get(this.uuid)).getValue()) == null) {
                state = this.isActive() ? "RUNNING" : "FAILED";
                a.setValue((Object)state);
            }
            a.setName(this.uuid);
            this.jobStatus = new CommandJobStatus(this.uuid, state, parent, this.control, this.rmVarMap, this.launchMode);
            this.jobStatus.setOwner(this.rmVarMap.getString("${ptp_rm:control.user.name#value}"));
            this.jobStatus.setQueueName(this.rmVarMap.getString("${ptp_rm:control.queue.name#value}"));
            if (!this.isBatch()) {
                this.jobStatus.setProcess(this.process);
            }
            this.jobStatus.setProxy(this.getProxy());
        }
        if (progress.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!this.jobStatus.getState().equals("COMPLETED")) {
            if (this.hasInput() && this.process != null && !this.process.isCompleted()) {
                this.runStatus = this.writeInputToProcess(this.process);
            }
            if (this.runStatus.isOK()) {
                for (SimpleCommandType cmd : this.command.getPostLaunchCmd()) {
                    SimpleCommandJob job = new SimpleCommandJob(this.uuid, cmd, this.command.getDirectory(), this.control, this.rmVarMap, this);
                    job.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                    job.schedule();
                    if (cmd.isWait()) {
                        try {
                            job.join();
                            if (cmd.isIgnoreExitStatus() || job.getResult().isOK()) continue;
                            this.terminate();
                            this.runStatus = job.getResult();
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.cmdJobs.add(job);
                }
            } else {
                this.terminate();
            }
        } else if (this.command.isKeepOpen() && "CANCELED".equals(this.jobStatus.getStateDetail())) {
            this.terminate();
        }
        return Status.OK_STATUS;
    }

    private void setErrStreamRedirection(IRemoteProcess process) throws CoreException {
        if (this.stderrTokenizer == null) {
            this.proxy.setErrMonitor(new CommandJobStreamMonitor(process.getErrorStream()));
        } else {
            PipedInputStream tokenizerErr = new PipedInputStream();
            this.tokenizerErr = tokenizerErr;
            PipedInputStream monitorErr = new PipedInputStream();
            try {
                this.errSplitter = new StreamSplitter(process.getErrorStream(), tokenizerErr, monitorErr);
            }
            catch (IOException e) {
                throw CoreExceptionUtils.newException((String)e.getMessage(), (Throwable)e);
            }
            this.proxy.setErrMonitor(new CommandJobStreamMonitor(monitorErr, null));
        }
        this.proxy.getErrorStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                CommandJob.this.error.append(text);
            }
        });
    }

    private void setOutStreamRedirection(IRemoteProcess process) throws CoreException {
        if (this.stdoutTokenizer == null) {
            this.proxy.setOutMonitor(new CommandJobStreamMonitor(process.getInputStream()));
        } else {
            PipedInputStream tokenizerOut = new PipedInputStream();
            this.tokenizerOut = tokenizerOut;
            PipedInputStream monitorOut = new PipedInputStream();
            try {
                this.outSplitter = new StreamSplitter(process.getInputStream(), tokenizerOut, monitorOut);
            }
            catch (IOException e) {
                throw CoreExceptionUtils.newException((String)e.getMessage(), (Throwable)e);
            }
            this.proxy.setOutMonitor(new CommandJobStreamMonitor(monitorOut, null));
        }
    }

    private void startConsumers() throws CoreException {
        if (this.outSplitter != null) {
            this.outSplitter.start();
        }
        if (this.errSplitter != null) {
            this.errSplitter.start();
        }
        this.proxy.startMonitors();
        if (this.isBatch()) {
            this.batchMonitors = new IStreamMonitor[2];
            this.batchMonitors[0] = this.proxy.getOutputStreamMonitor();
            this.batchMonitors[1] = this.proxy.getErrorStreamMonitor();
            this.proxy.setOutMonitor(null);
            this.proxy.setErrMonitor(null);
        }
        if (this.stdoutTokenizer != null) {
            try {
                this.stdoutTokenizer.setInputStream(this.tokenizerOut);
                this.stdoutT = new Thread(this.stdoutTokenizer);
                this.stdoutT.start();
            }
            catch (Throwable e) {
                throw CoreExceptionUtils.newException((String)Messages.StdoutParserError, (Throwable)e);
            }
        }
        if (this.stderrTokenizer != null) {
            try {
                this.stderrTokenizer.setInputStream(this.tokenizerErr);
                this.stderrT = new Thread(this.stderrTokenizer);
                this.stderrT.start();
            }
            catch (Throwable e) {
                throw CoreExceptionUtils.newException((String)Messages.StderrParserError, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void terminate() {
        if (this.active) {
            this.active = false;
            if (this.jobStatus != null) {
                this.jobStatus.cancelWait();
            }
            if (this.process != null && !this.process.isCompleted()) {
                IStatus status;
                this.process.destroy();
                if (this.proxy != null) {
                    this.proxy.close();
                }
                if (!(status = this.joinConsumers()).isOK()) {
                    JAXBControlCorePlugin.log(status);
                }
            }
            if (this.jobThread != null && this.jobThread != Thread.currentThread() && this.jobThread.isAlive()) {
                this.jobThread.interrupt();
            }
            for (SimpleCommandJob job : this.cmdJobs) {
                if (job.getState() != 4) continue;
                job.terminate();
            }
            this.cmdJobs.clear();
            this.cancel();
        }
    }

    @Override
    public boolean waitForId() {
        return this.command.isWaitForId();
    }

    private IStatus writeInputToProcess(IRemoteProcess process) {
        this.proxy.setInputStream(null);
        OutputStream stream = process.getOutputStream();
        try {
            stream.write(this.prepareInput().getBytes());
            stream.write(JAXBControlConstants.LINE_SEP.getBytes());
            stream.flush();
            this.proxy.setInputStream(stream);
        }
        catch (IOException | CoreException e) {
            return CoreExceptionUtils.getErrorStatus((String)Messages.ProcessRunError, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public static enum JobMode {
        BATCH,
        STATUS,
        INTERACTIVE;

    }

    private class StreamSplitter
    extends Thread {
        private final InputStream in;
        private final PipedOutputStream[] pout;
        private final List<BufferedOutputStream> boutList;

        private StreamSplitter(InputStream in, PipedInputStream pipe1, PipedInputStream pipe2) throws IOException {
            this.in = in;
            assert (pipe1 != null && pipe2 != null);
            this.pout = new PipedOutputStream[]{new PipedOutputStream(pipe1), new PipedOutputStream(pipe2)};
            this.boutList = new ArrayList<BufferedOutputStream>();
            this.boutList.add(new BufferedOutputStream(this.pout[0], 8192));
            this.boutList.add(new BufferedOutputStream(this.pout[1], 8192));
        }

        @Override
        public void run() {
            BufferedInputStream bin = new BufferedInputStream(this.in);
            try {
                int i;
                while ((i = bin.read()) != -1) {
                    BufferedOutputStream stream = null;
                    Iterator<BufferedOutputStream> b = this.boutList.iterator();
                    while (b.hasNext()) {
                        try {
                            stream = b.next();
                            stream.write(i);
                            stream.flush();
                        }
                        catch (IOException dead) {
                            if (dead.getMessage().indexOf("dead") >= 0) {
                                b.remove();
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                                continue;
                            }
                            throw dead;
                        }
                    }
                }
            }
            catch (EOFException eof) {
            }
            catch (IOException t) {
                JAXBControlCorePlugin.log(t);
            }
            for (BufferedOutputStream b : this.boutList) {
                try {
                    b.close();
                }
                catch (IOException t) {
                    JAXBControlCorePlugin.log(t);
                }
            }
        }
    }
}

