/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.handler;

import java.util.List;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.gef.finder.PaletteEntryFinder;
import org.hamcrest.Matcher;

public class PaletteHandler {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static PaletteHandler instance;

    public static PaletteHandler getInstance() {
        if (instance == null) {
            instance = new PaletteHandler();
        }
        return instance;
    }

    public String getLabel(final PaletteEntry paletteEntry) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return paletteEntry.getLabel();
            }
        });
    }

    public void activateTool(final PaletteViewer paletteViewer, final ToolEntry toolEntry) {
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                paletteViewer.setActiveTool(toolEntry);
            }
        });
    }

    public ToolEntry getActiveTool(final PaletteViewer paletteViewer) {
        return (ToolEntry)Display.syncExec((ResultRunnable)new ResultRunnable<ToolEntry>(){

            public ToolEntry run() {
                return paletteViewer.getActiveTool();
            }
        });
    }

    public List<PaletteEntry> getPaletteEntries(final PaletteViewer paletteViewer, final Matcher<PaletteEntry> matcher) {
        return (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<PaletteEntry>>(){

            public List<PaletteEntry> run() {
                PaletteRoot paletteRoot = paletteViewer.getPaletteRoot();
                return new PaletteEntryFinder().find(paletteRoot, matcher);
            }
        });
    }
}

