/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.surround;

import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.ExceptionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.SurroundWithAnalyzer;

public class SurroundWithTryCatchAnalyzer
extends SurroundWithAnalyzer {
    private ISurroundWithTryCatchQuery fQuery;
    private ITypeBinding[] fExceptions;

    public SurroundWithTryCatchAnalyzer(IJavaScriptUnit unit, Selection selection, ISurroundWithTryCatchQuery query) throws JavaScriptModelException {
        super(unit, selection);
        this.fQuery = query;
    }

    public ITypeBinding[] getExceptions() {
        return this.fExceptions;
    }

    @Override
    public void endVisit(JavaScriptUnit node) {
        BodyDeclaration enclosingNode = null;
        if (!this.getStatus().hasFatalError() && this.hasSelectedNodes()) {
            enclosingNode = (BodyDeclaration)ASTNodes.getParent(this.getFirstSelectedNode(), BodyDeclaration.class);
        }
        super.endVisit(node);
        if (enclosingNode != null && !this.getStatus().hasFatalError()) {
            this.fExceptions = ExceptionAnalyzer.perform(enclosingNode, this.getSelection());
            if (this.fExceptions == null || this.fExceptions.length == 0) {
                if (this.fQuery == null) {
                    this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_noUncaughtExceptions);
                } else if (this.fQuery.catchRuntimeException()) {
                    this.fExceptions = new ITypeBinding[]{node.getAST().resolveWellKnownType("java.lang.RuntimeException")};
                }
            }
        }
    }
}

