/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.validation;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.xtext.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.xtext.ui.preferences.ScrolledPageContent;
import org.eclipse.xtext.ui.util.PixelConverter;
import org.eclipse.xtext.ui.validation.Messages;

public abstract class AbstractValidatorConfigurationBlock
extends OptionsConfigurationBlock {
    @Inject
    private IDialogSettings dialogSettings;
    private PixelConverter fPixelConverter;
    @Inject
    @Named(value="languageName")
    private String languageName;
    private static final String PROPERTY_PREFIX = "ValidatorConfiguration";

    protected AbstractValidatorConfigurationBlock() {
    }

    @Override
    public Control doCreateContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite commonComposite = this.createStyleTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        commonComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createStyleTabContent(Composite folder) {
        int nColumns = 3;
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 16448);
        description.setFont(description.getFont());
        description.setText("Select the severity level for the following optional " + this.lastSegment(this.languageName) + " compiler problems:");
        description.setLayoutData((Object)new GridData(1, 2, true, false, nColumns - 1, 1));
        this.fillSettingsPage(composite, nColumns, 0);
        this.addAdditionalComponentsToSettingsPage(composite, nColumns, 0);
        new Label(composite, 0);
        this.restoreSectionExpansionStates(this.getDialogSettings());
        return sc1;
    }

    protected IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    protected void addAdditionalComponentsToSettingsPage(Composite settingsPage, int nColumns, int defaultIndent) {
    }

    protected void adjustComboWidth(List<Combo> combos) {
        int withHint = -1;
        for (Combo comboBox : combos) {
            comboBox.pack(true);
            Point computeSize = comboBox.computeSize(-1, -1);
            int pixels = computeSize.x;
            if (pixels <= withHint) continue;
            withHint = pixels;
        }
        for (Combo comboBox : combos) {
            Object ld = comboBox.getLayoutData();
            if (!(ld instanceof GridData)) continue;
            GridData layoutData = (GridData)ld;
            layoutData.widthHint = withHint;
        }
    }

    private String lastSegment(String languageFQN) {
        String simplename = languageFQN;
        int lastDot = languageFQN.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < languageFQN.length() - 1) {
            simplename = languageFQN.substring(lastDot + 1, languageFQN.length());
        }
        return simplename;
    }

    protected abstract void fillSettingsPage(Composite var1, int var2, int var3);

    protected Composite createSection(String label, Composite composite, int nColumns) {
        ExpandableComposite excomposite = this.createStyleSection(composite, label, nColumns);
        Composite inner = new Composite((Composite)excomposite, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        excomposite.setClient((Control)inner);
        return inner;
    }

    @Override
    public String getPropertyPrefix() {
        return PROPERTY_PREFIX;
    }

    protected Combo addComboBox(String prefKey, String label, Composite parent, int indent) {
        String[] values = new String[]{"error", "warning", "info", "ignore"};
        String[] valueLabels = new String[]{Messages.ValidationConfigurationBlock_error, Messages.ValidationConfigurationBlock_warning, Messages.ValidationConfigurationBlock_info, Messages.ValidationConfigurationBlock_ignore};
        Combo comboBox = this.addComboBox(parent, label, prefKey, indent, values, valueLabels);
        return comboBox;
    }

    @Override
    protected Job getBuildJob(IProject project) {
        OptionsConfigurationBlock.BuildJob buildJob = new OptionsConfigurationBlock.BuildJob(Messages.ValidationConfigurationBlock_build_job_title, project);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = Messages.ValidationConfigurationBlock_build_dialog_title;
        String message = workspaceSettings ? Messages.ValidationConfigurationBlock_build_dailog_ws_message : Messages.ValidationConfigurationBlock_build_dailog_project_message;
        return new String[]{title, message};
    }

    @Override
    protected void validateSettings(String changedKey, String oldValue, String newValue) {
    }
}

