/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.common.ui.editmodel.AbstractEditModelCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;

public class RestoreViewerSelectionCommand
extends AbstractEditModelCommand {
    EditPartViewer viewer;
    List selectedModelObjects;
    boolean restoreOnUndo;
    boolean restoreOnRedo;

    public RestoreViewerSelectionCommand(EditPartViewer viewer, boolean restoreOnUndo, boolean restoreOnRedo) {
        this.viewer = viewer;
        this.restoreOnUndo = restoreOnUndo;
        this.restoreOnRedo = restoreOnRedo;
    }

    public void captureSelection() {
        this.selectedModelObjects = new ArrayList();
        Iterator it = this.viewer.getSelectedEditParts().iterator();
        while (it.hasNext()) {
            Object modelObject = ((EditPart)it.next()).getModel();
            if (modelObject == null) continue;
            this.selectedModelObjects.add(modelObject);
        }
    }

    public void execute() {
        if (this.selectedModelObjects == null) {
            this.captureSelection();
        }
    }

    protected void restoreSelection() {
        this.viewer.deselectAll();
        Map modelObject2EditPart = this.viewer.getEditPartRegistry();
        Iterator it = this.selectedModelObjects.iterator();
        while (it.hasNext()) {
            EditPart editPart = (EditPart)modelObject2EditPart.get(it.next());
            if (editPart == null) continue;
            this.viewer.appendSelection(editPart);
        }
    }

    public void undo() {
        if (this.restoreOnUndo) {
            this.restoreSelection();
        }
    }

    public void redo() {
        if (this.restoreOnRedo) {
            this.restoreSelection();
        }
    }

    public Resource[] getResources() {
        return EMPTY_RESOURCE_ARRAY;
    }

    public Resource[] getModifiedResources() {
        return EMPTY_RESOURCE_ARRAY;
    }
}

