/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.providers;

import java.util.Collection;
import java.util.List;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.Links;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.ui.details.providers.AbstractContentProvider;

public class LinkContentProvider
extends AbstractContentProvider {
    public static final int INCOMING = 0;
    public static final int OUTGOING = 1;
    public static final int DECLARED = 2;
    int fMode = 0;

    public LinkContentProvider(int mode) {
        this.fMode = mode;
    }

    @Override
    public void collectElements(Object input, List<Object> list) {
        if (input == null) {
            return;
        }
        if (this.fMode == 0) {
            this.collectIncoming(input, list);
            return;
        }
        if (this.fMode == 1) {
            this.collectOutgoing(input, list);
            return;
        }
        this.collectDeclaredLinks(input, list);
    }

    void collectDeclaredLinks(Object input, List<Object> list) {
        if (input == null) {
            return;
        }
        if (input instanceof Flow) {
            Flow flow = (Flow)input;
            Links links = flow.getLinks();
            if (links == null) {
                return;
            }
            list.addAll((Collection<Object>)links.getChildren());
            return;
        }
        if (input instanceof Activity) {
            Activity activty = (Activity)input;
            this.collectDeclaredLinks(activty.eContainer(), list);
        }
    }

    void collectIncoming(Object input, List<Object> list) {
        if (input instanceof Activity) {
            Activity activity = (Activity)input;
            Targets targets = activity.getTargets();
            if (targets == null) {
                return;
            }
            for (Object next : targets.getChildren()) {
                Target aTarget = (Target)next;
                list.add(aTarget.getLink());
            }
        }
    }

    void collectOutgoing(Object input, List<Object> list) {
        if (input instanceof Activity) {
            Activity activity = (Activity)input;
            Sources sources = activity.getSources();
            if (sources == null) {
                return;
            }
            for (Object next : sources.getChildren()) {
                Source aSource = (Source)next;
                list.add(aSource.getLink());
            }
        }
    }
}

