/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IBreakpointsExtension;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMIBreakpointPathAdjuster;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointDMData;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.MIWatchpointScopeEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.CLICatchInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakListInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MIBreakpoints
extends AbstractDsfService
implements IBreakpointsExtension,
IMIBreakpointPathAdjuster {
    public static final String PREFIX = "org.eclipse.cdt.dsf.debug.breakpoint";
    public static final String BREAKPOINT_TYPE = "org.eclipse.cdt.dsf.debug.breakpoint.type";
    public static final String BREAKPOINT = "breakpoint";
    public static final String WATCHPOINT = "watchpoint";
    public static final String CATCHPOINT = "catchpoint";
    public static final String TRACEPOINT = "tracepoint";
    public static final String DYNAMICPRINTF = "dynamicPrintf";
    public static final String FILE_NAME = "org.eclipse.cdt.dsf.debug.breakpoint.fileName";
    public static final String LINE_NUMBER = "org.eclipse.cdt.dsf.debug.breakpoint.lineNumber";
    public static final String FUNCTION = "org.eclipse.cdt.dsf.debug.breakpoint.function";
    public static final String ADDRESS = "org.eclipse.cdt.dsf.debug.breakpoint.address";
    public static final String CONDITION = "org.eclipse.cdt.dsf.debug.breakpoint.condition";
    public static final String IGNORE_COUNT = "org.eclipse.cdt.dsf.debug.breakpoint.ignoreCount";
    public static final String PASS_COUNT = "org.eclipse.cdt.dsf.debug.breakpoint.passCount";
    public static final String IS_ENABLED = "org.eclipse.cdt.dsf.debug.breakpoint.isEnabled";
    public static final String COMMANDS = "org.eclipse.cdt.dsf.debug.breakpoint.commands";
    public static final String EXPRESSION = "org.eclipse.cdt.dsf.debug.breakpoint.expression";
    public static final String READ = "org.eclipse.cdt.dsf.debug.breakpoint.read";
    public static final String WRITE = "org.eclipse.cdt.dsf.debug.breakpoint.write";
    public static final String RANGE = "org.eclipse.cdt.dsf.debug.breakpoint.range";
    public static final String MEMSPACE = "org.eclipse.cdt.dsf.debug.breakpoint.memoryspace";
    public static final String PRINTF_STRING = "org.eclipse.cdt.dsf.debug.breakpoint.printf_string";
    public static final String CATCHPOINT_TYPE = "org.eclipse.cdt.dsf.debug.breakpoint.catchpoint_type";
    public static final String CATCHPOINT_ARGS = "org.eclipse.cdt.dsf.debug.breakpoint.catchpoint_args";
    private ICommandControl fConnection;
    private IMIRunControl fRunControl;
    private CommandFactory fCommandFactory;
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<String, MIBreakpointDMData>> fBreakpoints = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<String, MIBreakpointDMData>>();
    private Map<IRunControl.IExecutionDMContext, IBreakpoints.IBreakpointDMContext[]> fBreakpointHitMap = new HashMap<IRunControl.IExecutionDMContext, IBreakpoints.IBreakpointDMContext[]>();
    public static final String NULL_STRING = "";
    public static final String UNKNOWN_EXECUTION_CONTEXT = "Unknown execution context";
    public static final String UNKNOWN_BREAKPOINT_CONTEXT = "Unknown breakpoint context";
    public static final String UNKNOWN_BREAKPOINT_TYPE = "Unknown breakpoint type";
    public static final String UNKNOWN_BREAKPOINT = "Unknown breakpoint";
    public static final String BREAKPOINT_INSERTION_FAILURE = "Breakpoint insertion failure";
    public static final String WATCHPOINT_INSERTION_FAILURE = "Watchpoint insertion failure";
    public static final String INVALID_CONDITION = "Invalid condition";
    public static final String TRACEPOINT_INSERTION_FAILURE = "Tracepoint insertion failure";
    public static final String DYNAMIC_PRINTF_INSERTION_FAILURE = "Dynamic printf insertion failure";
    public static final String INVALID_BREAKPOINT_TYPE = "Invalid breakpoint type";
    public static final String CATCHPOINT_INSERTION_FAILURE = "Catchpoint insertion failure";

    protected Map<String, MIBreakpointDMData> getBreakpointMap(IBreakpoints.IBreakpointsTargetDMContext ctx) {
        return this.fBreakpoints.get(ctx);
    }

    protected Map<String, MIBreakpointDMData> createNewBreakpointMap(IBreakpoints.IBreakpointsTargetDMContext ctx) {
        HashMap<String, MIBreakpointDMData> map = new HashMap<String, MIBreakpointDMData>();
        this.fBreakpoints.put(ctx, map);
        return map;
    }

    @ThreadSafe
    public MIBreakpointDMData createMIBreakpointDMData(MIBreakpoint breakpoint) {
        MIBreakpointDMData data = new MIBreakpointDMData(breakpoint);
        return data;
    }

    @ThreadSafe
    public MIBreakpoint createMIBreakpoint(MITuple tuple) {
        return new MIBreakpoint(tuple);
    }

    public MIBreakpoints(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                MIBreakpoints.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fRunControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IBreakpoints.class.getName(), IBreakpointsExtension.class.getName(), MIBreakpoints.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(rm);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIWatchpointScopeEvent e) {
        Map<String, MIBreakpointDMData> contextBps;
        IBreakpoints.IBreakpointsTargetDMContext bpContext = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
        if (bpContext != null && (contextBps = this.getBreakpointMap(bpContext)) != null) {
            contextBps.remove(e.getNumber());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
    }

    public void getBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext context, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]> drm) {
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_EXECUTION_CONTEXT, null));
            drm.done();
            return;
        }
        final Map<String, MIBreakpointDMData> breakpointContext = this.getBreakpointMap(context);
        if (breakpointContext == null) {
            drm.setData((Object)new IBreakpoints.IBreakpointDMContext[0]);
            drm.done();
            return;
        }
        this.fConnection.queueCommand(this.fCommandFactory.createMIBreakList(context), (DataRequestMonitor)new DataRequestMonitor<MIBreakListInfo>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                breakpointContext.clear();
                MIBreakpoint[] breakpoints = ((MIBreakListInfo)this.getData()).getMIBreakpoints();
                IBreakpoints.IBreakpointDMContext[] result = new IBreakpoints.IBreakpointDMContext[breakpoints.length];
                int i = 0;
                while (i < breakpoints.length) {
                    MIBreakpointDMData breakpoint = MIBreakpoints.this.createMIBreakpointDMData(breakpoints[i]);
                    String reference = breakpoint.getReference();
                    result[i] = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                    breakpointContext.put(reference, breakpoint);
                    ++i;
                }
                drm.setData((Object)result);
                drm.done();
            }
        });
    }

    public void getBreakpointDMData(IBreakpoints.IBreakpointDMContext dmc, DataRequestMonitor<IBreakpoints.IBreakpointDMData> drm) {
        if (dmc == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            drm.done();
            return;
        }
        if (!(dmc instanceof MIBreakpointDMContext)) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_TYPE, null));
            drm.done();
            return;
        }
        MIBreakpointDMContext breakpoint = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)breakpoint, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_EXECUTION_CONTEXT, null));
            drm.done();
            return;
        }
        Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT, null));
            drm.done();
            return;
        }
        MIBreakpointDMData breakpointDMData = contextBreakpoints.get(breakpoint.getReference());
        MIBreakpointDMData breakpointDMDataCopy = breakpointDMData.copy();
        drm.setData((Object)breakpointDMDataCopy);
        drm.done();
    }

    public void insertBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        String type;
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_EXECUTION_CONTEXT, null));
            drm.done();
            return;
        }
        Map<String, MIBreakpointDMData> breakpointContext = this.getBreakpointMap(context);
        if (breakpointContext == null) {
            breakpointContext = this.createNewBreakpointMap(context);
        }
        if ((type = (String)attributes.get(BREAKPOINT_TYPE)) == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_TYPE, null));
            drm.done();
            return;
        }
        if (type.equals(BREAKPOINT)) {
            this.addBreakpoint(context, attributes, drm);
        } else if (type.equals(WATCHPOINT)) {
            this.addWatchpoint(context, attributes, drm);
        } else if (type.equals(TRACEPOINT)) {
            this.addTracepoint(context, attributes, drm);
        } else if (type.equals(CATCHPOINT)) {
            this.addCatchpoint(context, attributes, drm);
        } else if (type.equals(DYNAMICPRINTF)) {
            this.addDynamicPrintf(context, attributes, drm);
        } else {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_TYPE, null));
            drm.done();
        }
    }

    public void getExecutionContextBreakpoints(IRunControl.IExecutionDMContext ctx, DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]> rm) {
        IBreakpoints.IBreakpointDMContext[] bps = this.fBreakpointHitMap.get(ctx);
        if (bps == null && ctx instanceof IRunControl.IContainerDMContext) {
            ArrayList<IBreakpoints.IBreakpointDMContext> bpsList = new ArrayList<IBreakpoints.IBreakpointDMContext>(1);
            for (Map.Entry<IRunControl.IExecutionDMContext, IBreakpoints.IBreakpointDMContext[]> entry : this.fBreakpointHitMap.entrySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)((IDMContext)entry.getKey()), (IDMContext)ctx)) continue;
                IBreakpoints.IBreakpointDMContext[] iBreakpointDMContextArray = entry.getValue();
                int n = iBreakpointDMContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoints.IBreakpointDMContext bp = iBreakpointDMContextArray[n2];
                    bpsList.add(bp);
                    ++n2;
                }
            }
            bps = bpsList.toArray(new IBreakpoints.IBreakpointDMContext[bpsList.size()]);
        }
        rm.setData((Object)(bps != null ? bps : new IBreakpoints.IBreakpointDMContext[]{}));
        rm.done();
    }

    public Object getProperty(Map<String, Object> map, String key, Object defaultValue) {
        return map.containsKey(key) && map.get(key) != null ? map.get(key) : defaultValue;
    }

    protected String formatLocation(Map<String, Object> attributes) {
        int paren;
        String location = (String)this.getProperty(attributes, ADDRESS, NULL_STRING);
        String fileName = (String)this.getProperty(attributes, FILE_NAME, NULL_STRING);
        Integer lineNumber = (Integer)this.getProperty(attributes, LINE_NUMBER, -1);
        String function = (String)this.getProperty(attributes, FUNCTION, NULL_STRING);
        if (fileName.contains(" ")) {
            fileName = "\"" + fileName + "\"";
        }
        if ((paren = function.indexOf(40)) != -1) {
            function = function.substring(0, paren);
        }
        if (!fileName.equals(NULL_STRING)) {
            location = !function.equals(NULL_STRING) ? String.valueOf(fileName) + ":" + function : String.valueOf(fileName) + ":" + lineNumber;
        } else if (!function.equals(NULL_STRING)) {
            location = function;
        } else if (!location.isEmpty() && Character.isDigit(location.charAt(0))) {
            location = String.valueOf('*') + location;
        }
        return location;
    }

    protected void addBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> finalRm) {
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            finalRm.done();
            return;
        }
        final String location = this.formatLocation(attributes);
        if (location.equals(NULL_STRING)) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            finalRm.done();
            return;
        }
        final Boolean isTemporary = (Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary", false);
        final Boolean isHardware = (Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.isHardware", false);
        final String condition = (String)this.getProperty(attributes, CONDITION, NULL_STRING);
        final Integer ignoreCount = (Integer)this.getProperty(attributes, IGNORE_COUNT, 0);
        final String threadId = (String)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.threadId", "0");
        Sequence.Step insertBreakpointStep = new Sequence.Step(){

            public void execute(final RequestMonitor rm) {
                MIBreakpoints.this.fConnection.queueCommand(MIBreakpoints.this.fCommandFactory.createMIBreakInsert(context, isTemporary, isHardware, condition, ignoreCount, location, threadId), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)MIBreakpoints.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        if (((MIBreakInsertInfo)this.getData()).getMIBreakpoints().length == 0) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.BREAKPOINT_INSERTION_FAILURE, null));
                            rm.done();
                            return;
                        }
                        MIBreakpointDMData newBreakpoint = MIBreakpoints.this.createMIBreakpointDMData(((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0]);
                        String reference = newBreakpoint.getNumber();
                        if (reference.isEmpty()) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.BREAKPOINT_INSERTION_FAILURE, null));
                            rm.done();
                            return;
                        }
                        contextBreakpoints.put(reference, newBreakpoint);
                        MIBreakpointDMContext dmc = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                        finalRm.setData((Object)dmc);
                        MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointAddedEvent(dmc), MIBreakpoints.this.getProperties());
                        HashMap<String, Object> delta = new HashMap<String, Object>();
                        delta.put(MIBreakpoints.IS_ENABLED, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.IS_ENABLED, true));
                        MIBreakpoints.this.modifyBreakpoint(dmc, delta, rm, false);
                    }

                    protected void handleError() {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.BREAKPOINT_INSERTION_FAILURE, this.getStatus().getException()));
                        rm.done();
                    }
                });
            }
        };
        this.fRunControl.executeWithTargetAvailable((IDMContext)context, new Sequence.Step[]{insertBreakpointStep}, (RequestMonitor)finalRm);
    }

    protected void addTracepoint(IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_TYPE, null));
        drm.done();
    }

    protected void addWatchpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            drm.done();
            return;
        }
        String expression = (String)this.getProperty(attributes, EXPRESSION, NULL_STRING);
        boolean isRead = (Boolean)this.getProperty(attributes, READ, false);
        boolean isWrite = (Boolean)this.getProperty(attributes, WRITE, false);
        expression = this.adjustWatchPointExpression(attributes, expression);
        DataRequestMonitor<MIBreakInsertInfo> addWatchpointDRM = new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                if (((MIBreakInsertInfo)this.getData()).getMIBreakpoints().length == 0) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.WATCHPOINT_INSERTION_FAILURE, null));
                    drm.done();
                    return;
                }
                MIBreakpointDMData newBreakpoint = MIBreakpoints.this.createMIBreakpointDMData(((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0]);
                String reference = newBreakpoint.getNumber();
                if (reference.isEmpty()) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.WATCHPOINT_INSERTION_FAILURE, null));
                    drm.done();
                    return;
                }
                contextBreakpoints.put(reference, newBreakpoint);
                MIBreakpointDMContext dmc = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                drm.setData((Object)dmc);
                MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointAddedEvent(dmc), MIBreakpoints.this.getProperties());
                HashMap<String, Object> delta = new HashMap<String, Object>();
                delta.put(MIBreakpoints.CONDITION, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.CONDITION, MIBreakpoints.NULL_STRING));
                delta.put(MIBreakpoints.IGNORE_COUNT, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.IGNORE_COUNT, 0));
                delta.put(MIBreakpoints.IS_ENABLED, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.IS_ENABLED, true));
                MIBreakpoints.this.modifyBreakpoint(dmc, delta, (RequestMonitor)drm, false);
            }

            protected void handleError() {
                drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.WATCHPOINT_INSERTION_FAILURE, this.getStatus().getException()));
                drm.done();
            }
        };
        this.fConnection.queueCommand(this.fCommandFactory.createMIBreakWatch(context, isRead, isWrite, expression), (DataRequestMonitor)addWatchpointDRM);
    }

    protected String adjustWatchPointExpression(Map<String, Object> attributes, String origExpression) {
        String adjustedExpression = origExpression;
        if (!origExpression.isEmpty() && Character.isDigit(origExpression.charAt(0))) {
            adjustedExpression = "*" + origExpression;
        }
        return adjustedExpression;
    }

    protected void addCatchpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> finalRm) {
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            finalRm.done();
            return;
        }
        assert (!((Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.isTemporary", false)).booleanValue());
        assert (!((Boolean)this.getProperty(attributes, "org.eclipse.cdt.dsf.debug.breakpoint.mi.isHardware", false)).booleanValue());
        final String event = (String)this.getProperty(attributes, CATCHPOINT_TYPE, NULL_STRING);
        final String[] args = (String[])this.getProperty(attributes, CATCHPOINT_ARGS, null);
        Sequence.Step insertBreakpointStep = new Sequence.Step(){

            public void execute(final RequestMonitor rm) {
                MIBreakpoints.this.fConnection.queueCommand(MIBreakpoints.this.fCommandFactory.createCLICatch(context, event, args == null ? new String[]{} : args), (DataRequestMonitor)new DataRequestMonitor<CLICatchInfo>((Executor)MIBreakpoints.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        MIBreakpoint miBkpt = ((CLICatchInfo)this.getData()).getMIBreakpoint();
                        if (miBkpt == null) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.CATCHPOINT_INSERTION_FAILURE, null));
                            rm.done();
                            return;
                        }
                        MIBreakpointDMData newBreakpoint = MIBreakpoints.this.createMIBreakpointDMData(miBkpt);
                        String reference = newBreakpoint.getNumber();
                        if (reference.isEmpty()) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.CATCHPOINT_INSERTION_FAILURE, null));
                            rm.done();
                            return;
                        }
                        contextBreakpoints.put(reference, newBreakpoint);
                        MIBreakpointDMContext dmc = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                        finalRm.setData((Object)dmc);
                        MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointAddedEvent(dmc), MIBreakpoints.this.getProperties());
                        HashMap<String, Object> delta = new HashMap<String, Object>();
                        delta.put(MIBreakpoints.CONDITION, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.CONDITION, MIBreakpoints.NULL_STRING));
                        delta.put(MIBreakpoints.IGNORE_COUNT, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.IGNORE_COUNT, 0));
                        delta.put(MIBreakpoints.IS_ENABLED, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.IS_ENABLED, true));
                        MIBreakpoints.this.modifyBreakpoint(dmc, delta, rm, false);
                    }

                    protected void handleError() {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.CATCHPOINT_INSERTION_FAILURE, this.getStatus().getException()));
                        rm.done();
                    }
                });
            }
        };
        this.fRunControl.executeWithTargetAvailable((IDMContext)context, new Sequence.Step[]{insertBreakpointStep}, (RequestMonitor)finalRm);
    }

    protected void addDynamicPrintf(IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        drm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, "Dynamic-Printf usage in CDT requires GDB 7.7 or later", null));
        drm.done();
    }

    public void removeBreakpoint(final IBreakpoints.IBreakpointDMContext dmc, final RequestMonitor finalRm) {
        if (dmc == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            finalRm.done();
            return;
        }
        if (!(dmc instanceof MIBreakpointDMContext)) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_TYPE, null));
            finalRm.done();
            return;
        }
        MIBreakpointDMContext breakpointCtx = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (context == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_EXECUTION_CONTEXT, null));
            finalRm.done();
            return;
        }
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT, null));
            finalRm.done();
            return;
        }
        final String reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        if (breakpoint == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT, null));
            finalRm.done();
            return;
        }
        this.deleteBreakpointFromTarget(context, reference, new RequestMonitor(ImmediateExecutor.getInstance(), finalRm){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointRemovedEvent(dmc), MIBreakpoints.this.getProperties());
                    contextBreakpoints.remove(reference);
                }
                finalRm.done();
            }
        });
    }

    public void updateBreakpoint(IBreakpoints.IBreakpointDMContext dmc, Map<String, Object> properties, RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            rm.done();
            return;
        }
        if (!(dmc instanceof MIBreakpointDMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_TYPE, null));
            rm.done();
            return;
        }
        MIBreakpointDMContext breakpointCtx = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_EXECUTION_CONTEXT, null));
            rm.done();
            return;
        }
        Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT, null));
            rm.done();
            return;
        }
        String reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        if (breakpoint == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT, null));
            rm.done();
            return;
        }
        this.modifyBreakpoint(dmc, properties, rm, true);
    }

    protected void modifyBreakpoint(final IBreakpoints.IBreakpointDMContext dmc, Map<String, Object> attributes, final RequestMonitor rm, final boolean generateUpdateEvent) {
        String enableAttribute;
        String ignoreCountAttribute;
        HashMap<String, Object> properties = new HashMap<String, Object>(attributes);
        MIBreakpointDMContext breakpointCtx = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        String reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        int numberOfChanges = 0;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (generateUpdateEvent) {
                    MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointUpdatedEvent(dmc), MIBreakpoints.this.getProperties());
                }
                rm.done();
            }
        };
        String conditionAttribute = CONDITION;
        if (properties.containsKey(conditionAttribute)) {
            String oldValue = breakpoint.getCondition();
            String newValue = (String)properties.get(conditionAttribute);
            if (newValue == null) {
                newValue = NULL_STRING;
            }
            if (!oldValue.equals(newValue)) {
                this.changeCondition(context, reference, newValue, (RequestMonitor)countingRm);
                ++numberOfChanges;
            }
            properties.remove(conditionAttribute);
        }
        if (properties.containsKey(ignoreCountAttribute = IGNORE_COUNT)) {
            Integer oldValue = breakpoint.getIgnoreCount();
            Integer newValue = (Integer)properties.get(ignoreCountAttribute);
            if (newValue == null) {
                newValue = 0;
            }
            if (!oldValue.equals(newValue)) {
                this.changeIgnoreCount(context, reference, newValue, (RequestMonitor)countingRm);
                ++numberOfChanges;
            }
            properties.remove(ignoreCountAttribute);
        }
        if (properties.containsKey(enableAttribute = IS_ENABLED)) {
            Boolean oldValue = breakpoint.isEnabled();
            Boolean newValue = (Boolean)properties.get(enableAttribute);
            if (newValue == null) {
                newValue = false;
            }
            if (!oldValue.equals(newValue)) {
                ++numberOfChanges;
                if (newValue.booleanValue()) {
                    this.enableBreakpoint(context, reference, (RequestMonitor)countingRm);
                } else {
                    this.disableBreakpoint(context, reference, (RequestMonitor)countingRm);
                }
            }
            properties.remove(enableAttribute);
        }
        countingRm.setDoneCount(numberOfChanges);
    }

    protected void changeCondition(final IBreakpoints.IBreakpointsTargetDMContext context, final String reference, final String condition, RequestMonitor finalRm) {
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            finalRm.done();
            return;
        }
        Sequence.Step changeConditionStep = new Sequence.Step(){

            public void execute(final RequestMonitor rm) {
                MIBreakpoints.this.fConnection.queueCommand(MIBreakpoints.this.fCommandFactory.createMIBreakCondition(context, reference, condition), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)MIBreakpoints.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                        if (breakpoint == null) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.UNKNOWN_BREAKPOINT, null));
                            rm.done();
                            return;
                        }
                        breakpoint.setCondition(condition);
                        rm.done();
                    }

                    protected void handleError() {
                        MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                        if (breakpoint == null) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.UNKNOWN_BREAKPOINT, null));
                            rm.done();
                            return;
                        }
                        breakpoint.setCondition(MIBreakpoints.NULL_STRING);
                        (this).MIBreakpoints.this.fConnection.queueCommand((this).MIBreakpoints.this.fCommandFactory.createMIBreakCondition(context, reference, MIBreakpoints.NULL_STRING), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)MIBreakpoints.this.getExecutor(), rm){

                            protected void handleCompleted() {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.INVALID_CONDITION, null));
                                rm.done();
                            }
                        });
                    }
                });
            }
        };
        this.fRunControl.executeWithTargetAvailable((IDMContext)context, new Sequence.Step[]{changeConditionStep}, finalRm);
    }

    protected void changeIgnoreCount(final IBreakpoints.IBreakpointsTargetDMContext context, final String reference, final int ignoreCount, RequestMonitor finalRm) {
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            finalRm.done();
            return;
        }
        Sequence.Step changeIgnoreCountStep = new Sequence.Step(){

            public void execute(final RequestMonitor rm) {
                MIBreakpoints.this.fConnection.queueCommand(MIBreakpoints.this.fCommandFactory.createMIBreakAfter(context, reference, ignoreCount), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)MIBreakpoints.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                        if (breakpoint == null) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.UNKNOWN_BREAKPOINT, null));
                            rm.done();
                            return;
                        }
                        breakpoint.setIgnoreCount(ignoreCount);
                        rm.done();
                    }
                });
            }
        };
        this.fRunControl.executeWithTargetAvailable((IDMContext)context, new Sequence.Step[]{changeIgnoreCountStep}, finalRm);
    }

    protected void enableBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final String reference, RequestMonitor finalRm) {
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            finalRm.done();
            return;
        }
        Sequence.Step enableBreakpointStep = new Sequence.Step(){

            public void execute(final RequestMonitor rm) {
                MIBreakpoints.this.fConnection.queueCommand(MIBreakpoints.this.fCommandFactory.createMIBreakEnable(context, new String[]{reference}), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)MIBreakpoints.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                        if (breakpoint == null) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.UNKNOWN_BREAKPOINT, null));
                            rm.done();
                            return;
                        }
                        breakpoint.setEnabled(true);
                        rm.done();
                    }
                });
            }
        };
        this.fRunControl.executeWithTargetAvailable((IDMContext)context, new Sequence.Step[]{enableBreakpointStep}, finalRm);
    }

    protected void disableBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final String reference, RequestMonitor finalRm) {
        final Map<String, MIBreakpointDMData> contextBreakpoints = this.getBreakpointMap(context);
        if (contextBreakpoints == null) {
            finalRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, UNKNOWN_BREAKPOINT_CONTEXT, null));
            finalRm.done();
            return;
        }
        Sequence.Step disableBreakpointStep = new Sequence.Step(){

            public void execute(final RequestMonitor rm) {
                MIBreakpoints.this.fConnection.queueCommand(MIBreakpoints.this.fCommandFactory.createMIBreakDisable(context, new String[]{reference}), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)MIBreakpoints.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                        if (breakpoint == null) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, MIBreakpoints.UNKNOWN_BREAKPOINT, null));
                            rm.done();
                            return;
                        }
                        breakpoint.setEnabled(false);
                        rm.done();
                    }
                });
            }
        };
        this.fRunControl.executeWithTargetAvailable((IDMContext)context, new Sequence.Step[]{disableBreakpointStep}, finalRm);
    }

    protected void deleteBreakpointFromTarget(final IBreakpoints.IBreakpointsTargetDMContext context, final String reference, RequestMonitor finalRm) {
        Sequence.Step deleteBreakpointStep = new Sequence.Step(){

            public void execute(RequestMonitor rm) {
                MIBreakpoints.this.fConnection.queueCommand(MIBreakpoints.this.fCommandFactory.createMIBreakDelete(context, new String[]{reference}), new DataRequestMonitor((Executor)MIBreakpoints.this.getExecutor(), rm));
            }
        };
        this.fRunControl.executeWithTargetAvailable((IDMContext)context, new Sequence.Step[]{deleteBreakpointStep}, finalRm);
    }

    @DsfServiceEventHandler
    public void eventDispatched(IBreakpointsExtension.IBreakpointHitDMEvent e) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            IRunControl.IExecutionDMContext[] triggeringContexts = ((IRunControl.IContainerSuspendedDMEvent)e).getTriggeringContexts();
            if (triggeringContexts != null) {
                IRunControl.IExecutionDMContext[] iExecutionDMContextArray = triggeringContexts;
                int n = triggeringContexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IRunControl.IExecutionDMContext ctx = iExecutionDMContextArray[n2];
                    this.fBreakpointHitMap.put(ctx, e.getBreakpoints());
                    ++n2;
                }
            } else {
                this.fBreakpointHitMap.put((IRunControl.IExecutionDMContext)e.getDMContext(), e.getBreakpoints());
            }
        } else {
            this.fBreakpointHitMap.put((IRunControl.IExecutionDMContext)e.getDMContext(), e.getBreakpoints());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.clearBreakpointHitForContainer((IRunControl.IContainerDMContext)e.getDMContext());
        } else {
            this.fBreakpointHitMap.remove(e.getDMContext());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e.getDMContext() instanceof IRunControl.IContainerDMContext) {
            this.clearBreakpointHitForContainer((IRunControl.IContainerDMContext)e.getDMContext());
        } else {
            this.fBreakpointHitMap.remove(e.getDMContext());
        }
    }

    private void clearBreakpointHitForContainer(IRunControl.IContainerDMContext container) {
        Iterator<Map.Entry<IRunControl.IExecutionDMContext, IBreakpoints.IBreakpointDMContext[]>> itr = this.fBreakpointHitMap.entrySet().iterator();
        while (itr.hasNext()) {
            if (!DMContexts.isAncestorOf((IDMContext)((IDMContext)itr.next().getKey()), (IDMContext)container)) continue;
            itr.remove();
        }
        this.fBreakpointHitMap.remove(container);
    }

    protected IBreakpoints.IBreakpointsTargetDMContext getBreakpointTargetContext(String reference) {
        for (IBreakpoints.IBreakpointsTargetDMContext context : this.fBreakpoints.keySet()) {
            Map<String, MIBreakpointDMData> map = this.fBreakpoints.get(context);
            if (map == null || !map.keySet().contains(reference)) continue;
            return context;
        }
        return null;
    }

    @Override
    public String adjustDebuggerPath(String originalPath) {
        String result = originalPath;
        if (Platform.getOS().startsWith("win") && !originalPath.startsWith("/")) {
            originalPath = originalPath.replace('\\', '/');
            result = originalPath.substring(originalPath.lastIndexOf(47) + 1);
        }
        return result;
    }

    public class BreakpointAddedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointsAddedEvent {
        public BreakpointAddedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }
    }

    public class BreakpointRemovedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointsRemovedEvent {
        public BreakpointRemovedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }
    }

    public class BreakpointUpdatedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointsUpdatedEvent {
        public BreakpointUpdatedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }
    }

    public class BreakpointsChangedEvent
    extends AbstractDMEvent<IBreakpoints.IBreakpointsTargetDMContext>
    implements IBreakpoints.IBreakpointsChangedEvent {
        private IBreakpoints.IBreakpointDMContext[] fEventBreakpoints;

        public BreakpointsChangedEvent(IBreakpoints.IBreakpointDMContext bp) {
            super((IDMContext)((IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)bp, IBreakpoints.IBreakpointsTargetDMContext.class)));
            this.fEventBreakpoints = new IBreakpoints.IBreakpointDMContext[]{bp};
        }

        public IBreakpoints.IBreakpointDMContext[] getBreakpoints() {
            return this.fEventBreakpoints;
        }
    }

    @Immutable
    public static final class MIBreakpointDMContext
    extends AbstractDMContext
    implements IBreakpoints.IBreakpointDMContext {
        private final String fReference;

        public MIBreakpointDMContext(MIBreakpoints service, IDMContext[] parents, String reference) {
            this(service.getSession().getId(), parents, reference);
        }

        public MIBreakpointDMContext(String sessionId, IDMContext[] parents, String reference) {
            super(sessionId, parents);
            this.fReference = reference;
        }

        public String getReference() {
            return this.fReference;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MIBreakpointDMContext)) {
                return false;
            }
            return this.baseEquals(obj) && this.fReference.equals(((MIBreakpointDMContext)((Object)obj)).fReference);
        }

        public int hashCode() {
            return this.baseHashCode() + this.fReference.hashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".reference(" + this.fReference + ")";
        }
    }
}

