/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.headlessbuilderapp;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.managedbuilder.internal.core.HeadlessBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class HeadlessBuilderWrapper
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        String[] arguments = (String[])context.getArguments().get("application.args");
        List<String> args = Arrays.asList(arguments);
        if (args.isEmpty() || args.contains("-help") || args.contains("--help")) {
            this.showUsage(context);
            return IApplication.EXIT_OK;
        }
        try {
            ResourcesPlugin.getWorkspace();
        }
        catch (NoClassDefFoundError noClassError) {
            BundleException bundleException;
            ClassNotFoundException classNotFoundException;
            if (noClassError.getCause() instanceof ClassNotFoundException && (classNotFoundException = (ClassNotFoundException)noClassError.getCause()).getException() instanceof BundleException && (bundleException = (BundleException)classNotFoundException.getException()).getCause() instanceof IllegalStateException) {
                System.err.println(Messages.bind(Messages.WorkspaceRequired));
                this.showUsage(context);
                return 1;
            }
            throw noClassError;
        }
        Object res = new HeadlessBuilder().start(context);
        if (res == HeadlessBuilder.SHOW_USAGE) {
            this.showUsage(context);
            return HeadlessBuilder.ERROR;
        }
        return res;
    }

    private void showUsage(IApplicationContext context) {
        String binaryName = "PROGRAM";
        System.out.println(NLS.bind((String)Messages.CommandLineUsage, (Object)binaryName));
    }

    public void stop() {
    }

    private static final class Messages
    extends NLS {
        private static final String BUNDLE_NAME = "org.eclipse.cdt.managedbuilder.internal.headlessbuilderapp.messages";
        public static String CommandLineUsage;
        public static String WorkspaceRequired;

        static {
            NLS.initializeMessages((String)BUNDLE_NAME, Messages.class);
        }

        private Messages() {
        }

        public static String bind(String message) {
            return Messages.bind(message, null);
        }

        public static String bind(String message, Object binding) {
            return Messages.bind(message, new Object[]{binding});
        }

        public static String bind(String message, Object binding1, Object binding2) {
            return Messages.bind(message, new Object[]{binding1, binding2});
        }

        public static String bind(String message, Object[] bindings) {
            return MessageFormat.format(message, bindings);
        }
    }
}

