/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.control;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.datatools.enablement.oda.xml.ui.control.IMenuActionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.control.MenuButton;
import org.eclipse.datatools.enablement.oda.xml.ui.control.RelativeFileSelectionDialog;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class FileSelectionButton {
    private static final int ABSOLUTE_PATH = 1;
    private static final int RELATIVE_PATH = 2;
    private IMenuActionHandler handler;
    private int defaultAction;
    private MenuButton menuButton;
    private Menu menu;
    private SelectionAdapter menuAction;

    public FileSelectionButton(Composite parent, int style) {
        this(parent, style, 2);
    }

    public FileSelectionButton(Composite parent, int style, int defaultAction) {
        this.menuButton = new MenuButton(parent, style);
        this.defaultAction = defaultAction;
        this.initMenuItems(false);
    }

    public void setText(String text) {
        this.menuButton.setText(text);
    }

    private void initSelectionListener() {
        this.menuAction = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof MenuItem) {
                    MenuItem item = (MenuItem)e.widget;
                    Integer type = (Integer)item.getData();
                    FileSelectionButton.this.handleFileSelection(type);
                } else if (e.widget instanceof MenuButton) {
                    FileSelectionButton.this.defaultAction = FileSelectionButton.this.handler != null && FileSelectionButton.this.handler.getBaseFolder() != null ? 2 : 1;
                    FileSelectionButton.this.handleFileSelection(FileSelectionButton.this.defaultAction);
                }
            }
        };
    }

    private void initMenuItems(boolean supportRelative) {
        if (this.menuAction == null) {
            this.initSelectionListener();
            this.menuButton.addSelectionListener((SelectionListener)this.menuAction);
        }
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu((Decorations)this.menuButton.getShell(), 8);
        MenuItem item = new MenuItem(this.menu, 8);
        item.setText(Messages.getString("FileSelectionButton.menuItem.absolutePath"));
        item.setData((Object)1);
        item.addSelectionListener((SelectionListener)this.menuAction);
        if (supportRelative) {
            MenuItem relativeItem = new MenuItem(this.menu, 8);
            relativeItem.setText(Messages.getString("FileSelectionButton.menuItem.relativePath"));
            relativeItem.setData((Object)2);
            relativeItem.addSelectionListener((SelectionListener)this.menuAction);
        }
        this.menuButton.setDropDownMenu(this.menu);
    }

    private void handleFileSelection(int selectionType) {
        if (this.handler == null) {
            return;
        }
        if (selectionType == 2) {
            RelativeFileSelectionDialog dialog = new RelativeFileSelectionDialog(this.menuButton.getShell(), this.handler.getBaseFolder(), this.handler.getExtensionsFilter());
            if (dialog.open() == 0) {
                try {
                    URI uri = dialog.getSelected();
                    if (uri != null) {
                        this.handler.setPath(uri.getPath());
                    }
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        } else if (selectionType == 1) {
            FileDialog dialog = new FileDialog(this.menuButton.getShell());
            dialog.setFilterExtensions(this.handler.getExtensionsFilter());
            String path = this.handler.getFilePath();
            if (path != null && path.trim().length() > 0) {
                File f = new File(path);
                if (f.exists() && f.isFile()) {
                    dialog.setFileName(path);
                } else {
                    dialog.setFilterPath(path);
                }
            } else {
                dialog.setFilterPath(this.handler.getBaseFolder());
            }
            String filePath = dialog.open();
            if (filePath != null) {
                this.handler.setPath(new File(filePath).getAbsolutePath());
            }
        }
    }

    public void setActionHandler(IMenuActionHandler action) {
        this.handler = action;
        if (this.handler.getBaseFolder() != null) {
            this.initMenuItems(true);
        }
    }
}

