/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.ICodeSelection;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.DelegatedOpen;
import org.eclipse.dltk.internal.ui.OpenDelegateManager;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.ui.IOpenDelegate;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.dltk.ui.infoviews.ModelElementArray;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ModelElementHyperlinkDetector
implements IHyperlinkDetector,
IHyperlinkDetectorExtension {
    private ITextEditor fTextEditor;

    public ModelElementHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ICodeSelection selection;
        IRegion wordRegion;
        OpenAction openAction;
        block14: {
            ISourceModule input;
            block13: {
                if (region == null || !(this.fTextEditor instanceof ScriptEditor)) {
                    return null;
                }
                IAction action = this.fTextEditor.getAction("OpenEditor");
                if (action == null || !(action instanceof OpenAction)) {
                    return null;
                }
                openAction = (OpenAction)action;
                int offset = region.getOffset();
                input = EditorUtility.getEditorInputModelElement((IEditorPart)this.fTextEditor, false);
                if (input == null) {
                    return null;
                }
                IDocument document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
                wordRegion = ScriptWordFinder.findWord(document, offset);
                if (wordRegion != null && wordRegion.getLength() != 0) break block13;
                return null;
            }
            selection = ((ICodeAssist)input).codeSelectAll(wordRegion.getOffset(), wordRegion.getLength());
            if (selection != null) break block14;
            return null;
        }
        try {
            ArrayList elements = new ArrayList(selection.size());
            for (Object element : selection) {
                if (element instanceof IModelElement) {
                    elements.add(element);
                    continue;
                }
                IOpenDelegate adapter = OpenDelegateManager.findFor(element);
                if (adapter == null) continue;
                elements.add(new DelegatedOpen(adapter, element));
            }
            if (!elements.isEmpty()) {
                ModelElementHyperlink link;
                if (elements.size() == 1) {
                    ISourceRange elementRange = selection.rangeOf(elements.get(0));
                    if (elementRange != null) {
                        wordRegion = new Region(elementRange.getOffset(), elementRange.getLength());
                    }
                    link = new ModelElementHyperlink(wordRegion, elements.get(0), openAction);
                } else {
                    link = new ModelElementHyperlink(wordRegion, new ModelElementArray(elements), openAction);
                }
                return new IHyperlink[]{link};
            }
        }
        catch (ModelException e) {
            return null;
        }
        return null;
    }

    public void dispose() {
        this.fTextEditor = null;
    }
}

