/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.view.multisegment.tooling;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.view.internal.control.multireference.MultiReferenceSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.table.model.VTableColumnConfiguration;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VWidthConfiguration;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.view.spi.multisegment.model.MultiSegmentUtil;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultisegmentPackage;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MultiSegmentChildDmrsSWTRenderer
extends MultiReferenceSWTRenderer {
    private AdapterImpl adapter;
    private VTableControl tableControl;
    private Button sortBtn;

    @Inject
    public MultiSegmentChildDmrsSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsLocalizationService localizationService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService, localizationService);
    }

    protected void postInit() {
        this.tableControl = (VTableControl)this.getViewModelContext().getDomainModel();
        super.postInit();
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Control renderControl = super.renderControl(cell, parent);
        this.adapter = new TableControlAdapter(parent, this.getTableViewer());
        this.tableControl.eAdapters().add((Object)this.adapter);
        this.addDragAndDropSupport(this.getTableViewer(), this.getEditingDomain((EObject)this.tableControl));
        return renderControl;
    }

    protected Composite createButtonComposite(Composite parent) throws DatabindingFailedException {
        Composite buttonComposite = super.createButtonComposite(parent);
        this.sortBtn = new Button(buttonComposite, 8);
        this.sortBtn.setText("Sort");
        this.sortBtn.addSelectionListener((SelectionListener)new SortSelectionAdapter());
        int buttonCount = buttonComposite.getChildren().length;
        GridLayoutFactory.fillDefaults().numColumns(buttonCount).equalWidth(false).applyTo(buttonComposite);
        return buttonComposite;
    }

    protected void updateButtonEnabling() {
        super.updateButtonEnabling();
        if (this.sortBtn != null) {
            this.sortBtn.setEnabled(this.getContainer().isPresent() && ((VControl)this.getVElement()).isEffectivelyEnabled());
        }
    }

    protected void updateButtonVisibility() {
        super.updateButtonVisibility();
        if (this.sortBtn != null) {
            this.sortBtn.setVisible(!((VControl)this.getVElement()).isEffectivelyReadonly());
        }
    }

    protected Optional<EObject> getContainer() {
        return this.getMultiSegment().map(EObject.class::cast);
    }

    protected EReference getEStructuralFeature() {
        return VMultisegmentPackage.Literals.MULTI_DOMAIN_MODEL_REFERENCE_SEGMENT__CHILD_DOMAIN_MODEL_REFERENCES;
    }

    protected boolean showAddExistingButton() {
        return false;
    }

    protected boolean showAddNewButton() {
        return true;
    }

    protected boolean showDeleteButton() {
        return true;
    }

    protected boolean showMoveUpButton() {
        return true;
    }

    protected boolean showMoveDownButton() {
        return true;
    }

    protected void handleAddNew(TableViewer tableViewer, EObject eObject, EStructuralFeature structuralFeature) {
        ReferenceService referenceService = (ReferenceService)this.getViewModelContext().getService(ReferenceService.class);
        referenceService.addNewModelElements(eObject, (EReference)structuralFeature, false);
    }

    protected IObservableList<?> getReferencedElementsList() throws DatabindingFailedException {
        if (this.tableControl == null) {
            throw new DatabindingFailedException("The TableControl was null. Therefore, the DMR that contains the multisegment cannot be accessed.");
        }
        Optional<VMultiDomainModelReferenceSegment> multiSegment = this.getMultiSegment();
        if (this.tableControl.getDomainModelReference() == null || !multiSegment.isPresent()) {
            return Observables.emptyObservableList();
        }
        VDomainModelReference childDmrsDMR = VViewFactory.eINSTANCE.createDomainModelReference();
        VFeatureDomainModelReferenceSegment featureSegment = VViewFactory.eINSTANCE.createFeatureDomainModelReferenceSegment();
        featureSegment.setDomainModelFeature(this.getEStructuralFeature().getName());
        childDmrsDMR.getSegments().add((Object)featureSegment);
        return this.getEMFFormsDatabinding().getObservableList(childDmrsDMR, (EObject)multiSegment.get());
    }

    private Optional<VMultiDomainModelReferenceSegment> getMultiSegment() {
        return MultiSegmentUtil.getMultiSegment((VDomainModelReference)this.tableControl.getDomainModelReference());
    }

    private void addDragAndDropSupport(TableViewer viewer, EditingDomain editingDomain) {
        int dndOperations = 2;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(2, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        EditingDomainViewerDropAdapter editingDomainViewerDropAdapter = new EditingDomainViewerDropAdapter(editingDomain, (Viewer)viewer);
        viewer.addDropSupport(2, transfers, (DropTargetListener)editingDomainViewerDropAdapter);
    }

    protected void dispose() {
        this.tableControl.eAdapters().remove((Object)this.adapter);
        super.dispose();
    }

    protected ILabelProvider createLabelProvider() {
        return new TableColumnsLabelProvider(this.getAdapterFactory());
    }

    private final class SortSelectionAdapter
    extends SelectionAdapter {
        private boolean down;

        private SortSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            Optional multiSegment = MultiSegmentChildDmrsSWTRenderer.this.getMultiSegment();
            if (!multiSegment.isPresent()) {
                return;
            }
            this.down = !this.down;
            ArrayList list = new ArrayList((List)((VMultiDomainModelReferenceSegment)multiSegment.get()).eGet((EStructuralFeature)MultiSegmentChildDmrsSWTRenderer.this.getEStructuralFeature(), true));
            Collections.sort(list, new Comparator<VDomainModelReference>(){

                @Override
                public int compare(VDomainModelReference o1, VDomainModelReference o2) {
                    String label1 = MultiSegmentChildDmrsSWTRenderer.this.getLabelProvider().getText((Object)o1);
                    String label2 = MultiSegmentChildDmrsSWTRenderer.this.getLabelProvider().getText((Object)o2);
                    int result = label1.compareTo(label2);
                    if (!SortSelectionAdapter.this.down) {
                        result *= -1;
                    }
                    return result;
                }
            });
            EditingDomain editingDomain = MultiSegmentChildDmrsSWTRenderer.this.getEditingDomain((EObject)multiSegment.get());
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, multiSegment.get(), (Object)MultiSegmentChildDmrsSWTRenderer.this.getEStructuralFeature(), list));
        }
    }

    private final class TableColumnsLabelProvider
    extends AdapterFactoryLabelProvider {
        private TableColumnsLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String text = super.getColumnText(object, columnIndex);
            if (columnIndex == 0 && VDomainModelReference.class.isInstance(object)) {
                for (VTableColumnConfiguration configuration : MultiSegmentChildDmrsSWTRenderer.this.tableControl.getColumnConfigurations()) {
                    VWidthConfiguration widthConfiguration;
                    if (!VWidthConfiguration.class.isInstance(configuration) || (widthConfiguration = (VWidthConfiguration)VWidthConfiguration.class.cast(configuration)).getColumnDomainReference() != object) continue;
                    return MessageFormat.format("{0} [minWidth={1}, weight={2}]", text, widthConfiguration.getMinWidth(), widthConfiguration.getWeight());
                }
            }
            return text;
        }
    }

    private final class TableControlAdapter
    extends AdapterImpl {
        private final Composite parent;
        private final TableViewer viewer;

        private TableControlAdapter(Composite parent, TableViewer viewer) {
            this.parent = parent;
            this.viewer = viewer;
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (VTableControl.class.isInstance(notification.getNotifier()) && notification.getFeature() == VViewPackage.eINSTANCE.getControl_DomainModelReference()) {
                MultiSegmentChildDmrsSWTRenderer.this.updateButtonEnabling();
                this.updateViewerInputObservableList();
                this.viewer.refresh();
                this.parent.layout();
            }
        }

        private void updateViewerInputObservableList() {
            try {
                MultiSegmentChildDmrsSWTRenderer.this.updateTableViewerInputList();
            }
            catch (DatabindingFailedException ex) {
                MultiSegmentChildDmrsSWTRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                this.viewer.setInput((Object)Observables.emptyObservableList());
                return;
            }
        }
    }
}

