/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.auth;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.transport.sshd.GssApiMechanisms;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.auth.AbstractAuthenticationHandler;
import org.ietf.jgss.GSSContext;

public abstract class GssApiAuthentication<ParameterType, TokenType>
extends AbstractAuthenticationHandler<ParameterType, TokenType> {
    private GSSContext context;
    protected byte[] token;

    public GssApiAuthentication(InetSocketAddress proxy) {
        super(proxy);
    }

    @Override
    public void close() {
        GssApiMechanisms.closeContextSilently(this.context);
        this.context = null;
        this.done = true;
    }

    @Override
    public final void start() throws Exception {
        try {
            this.context = this.createContext();
            this.context.requestMutualAuth(true);
            this.context.requestConf(false);
            this.context.requestInteg(false);
            byte[] empty = new byte[]{};
            this.token = this.context.initSecContext(empty, 0, 0);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    @Override
    public final void process() throws Exception {
        if (this.context == null) {
            throw new IOException(MessageFormat.format(SshdText.get().proxyCannotAuthenticate, this.proxy));
        }
        try {
            byte[] received = this.extractToken(this.params);
            this.token = this.context.initSecContext(received, 0, received.length);
            this.checkDone();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private void checkDone() throws Exception {
        this.done = this.context.isEstablished();
        if (this.done) {
            this.context.dispose();
            this.context = null;
        }
    }

    protected abstract GSSContext createContext() throws Exception;

    protected abstract byte[] extractToken(ParameterType var1) throws Exception;
}

