/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class ReverseDeque<E>
implements Deque<E>,
Serializable {
    private Deque<E> deque;
    private static final long serialVersionUID = 1L;

    public ReverseDeque(Deque<E> deque) {
        if (deque == null) {
            throw new NullPointerException();
        }
        this.deque = deque;
    }

    @Override
    public void enqueueTail(E element) {
        this.deque.enqueueHead(element);
    }

    @Override
    public void enqueueHead(E element) {
        this.deque.enqueueTail(element);
    }

    @Override
    public E dequeueHead() {
        return this.deque.dequeueTail();
    }

    @Override
    public E dequeueTail() {
        return this.deque.dequeueHead();
    }

    @Override
    public E peekHead() {
        return this.deque.peekTail();
    }

    @Override
    public E peekTail() {
        return this.deque.peekHead();
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.deque);
    }
}

