/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.commands.range.ApplyStyleCommand;
import org.eclipse.jst.pagedesigner.commands.range.Paragraph;
import org.eclipse.jst.pagedesigner.commands.range.ParagraphFinder;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.jst.pagedesigner.dom.EditHelper;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.dom.IDOMRefPosition;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ParagraphApplyStyleCommand
extends ApplyStyleCommand {
    private static final String[] HH = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};

    public ParagraphApplyStyleCommand(IHTMLGraphicalViewer viewer, String tag, String property, String value) {
        super(viewer, tag, property, value);
    }

    public ParagraphApplyStyleCommand(IHTMLGraphicalViewer viewer, Element node, String property, String value) {
        super(viewer, node, property, value);
    }

    protected DOMRange doRangeExecute(DOMRange range) {
        if (range != null) {
            boolean ordered = range.isOrdered();
            IDOMPosition start = ordered ? range.getStartPosition() : range.getEndPosition();
            IDOMPosition end = ordered ? range.getEndPosition() : range.getStartPosition();
            Node common = null;
            Node container = null;
            if (EditModelQuery.isSame(range)) {
                container = start.getContainerNode();
                ParagraphFinder finder = new ParagraphFinder(start);
                Paragraph p = finder.getParagraph(start);
                start = p.getStart();
                end = p.getEnd();
                common = p.getLowestContainer();
            } else {
                common = EditModelQuery.getInstance().getCommonAncestor(start, end);
            }
            DOMRange rt = this.replaceExistingH(start, end);
            if (rt != null) {
                return rt;
            }
            if (this.getTag().equalsIgnoreCase("p") && (rt = this.replaceExistingP(start, end)) != null) {
                return rt;
            }
            if (start.getContainerNode() == end.getContainerNode()) {
                int offset1 = start.getOffset();
                int offset2 = end.getOffset();
                IDOMPosition old = start;
                if ((start = this.split(start)) != old) {
                    container = start.getNextSiblingNode();
                    end = new DOMPosition(container, offset2 -= offset1);
                }
                end = this.split(end);
            } else {
                start = this.split(common, start);
                end = this.split(common, end);
            }
            range = this.InsertStyleTag(new DOMRange(start, end));
        }
        return range;
    }

    public boolean canExecute() {
        return true;
    }

    private IDOMPosition split(Node common, IDOMPosition position) {
        Assert.isTrue((boolean)EditModelQuery.isChild(common, position.getContainerNode()));
        Node container = position.getContainerNode();
        String[] styleNodes = new String[EditModelQuery.HTML_STYLE_NODES.size()];
        EditModelQuery.HTML_STYLE_NODES.toArray(styleNodes);
        while (EditModelQuery.isText(container) || container != common && EditModelQuery.containItem(styleNodes, container, true)) {
            IDOMPosition old = position;
            if (old == (position = EditHelper.splitNode(position))) {
                int pos = EditHelper.getLocation(position);
                switch (pos) {
                    case -1: {
                        position = new DOMRefPosition(position.getContainerNode(), false);
                        break;
                    }
                    case 1: {
                        position = new DOMRefPosition(position.getContainerNode(), true);
                    }
                }
            }
            Node containerBackup = container;
            container = container.getParentNode();
            if (!containerBackup.getNodeName().equalsIgnoreCase("p")) continue;
            container.removeChild(containerBackup);
        }
        return position;
    }

    private IDOMPosition split(IDOMPosition position) {
        Node container = position.getContainerNode();
        String[] styleNodes = new String[EditModelQuery.HTML_STYLE_NODES.size()];
        EditModelQuery.HTML_STYLE_NODES.toArray(styleNodes);
        if (EditModelQuery.isText(container) || EditModelQuery.containItem(styleNodes, container, true)) {
            return EditHelper.splitNode(position);
        }
        return position;
    }

    private DOMRange replaceExistingH(IDOMPosition start, IDOMPosition end) {
        Node common = EditModelQuery.getInstance().getCommonAncestor(start, end);
        if (Arrays.asList(HH).contains(ParagraphApplyStyleCommand.getAName(this.getTag()).toLowerCase()) && Arrays.asList(HH).contains(ParagraphApplyStyleCommand.getAName(common.getNodeName()).toLowerCase())) {
            if (ParagraphApplyStyleCommand.getAName(this.getTag()).toLowerCase().equalsIgnoreCase(ParagraphApplyStyleCommand.getAName(common.getNodeName()).toLowerCase())) {
                NodeList nodes = common.getChildNodes();
                int i = 0;
                int size = nodes.getLength();
                while (i < size) {
                    common.getParentNode().insertBefore(nodes.item(i), common);
                    ++i;
                }
                common.getParentNode().removeChild(common);
                return new DOMRange(start, end);
            }
            start = DOMPositionHelper.toDOMRefPosition(start);
            end = DOMPositionHelper.toDOMRefPosition(end);
            Element newHNode = EditModelQuery.getDocumentNode(common).createElement(this.getTag());
            EditModelQuery.copyChildren(common, newHNode);
            common.getParentNode().replaceChild(newHNode, common);
            return new DOMRange(start, end);
        }
        return null;
    }

    private DOMRange replaceExistingP(IDOMPosition start, IDOMPosition end) {
        Node startNode = start instanceof IDOMRefPosition ? start.getNextSiblingNode() : start.getContainerNode();
        Node endNode = end instanceof IDOMRefPosition ? end.getPreviousSiblingNode() : end.getContainerNode();
        Node parentNode = startNode.getParentNode();
        if (!start.isText() && start instanceof DOMPosition) {
            startNode = startNode.getChildNodes().item(start.getOffset());
            parentNode = start.getContainerNode();
        }
        if (!end.isText() && end instanceof DOMPosition) {
            endNode = endNode.getChildNodes().item(end.getOffset() - 1);
        }
        int len = 0;
        len = end.getOffset() - start.getOffset();
        if (startNode == endNode && startNode instanceof Text) {
            TextEditPart part = (TextEditPart)((INodeNotifier)startNode).getAdapterFor(EditPart.class);
            boolean condition = false;
            if (start instanceof IDOMRefPosition || start instanceof DOMPosition && !start.isText()) {
                condition = parentNode.getNodeName().equalsIgnoreCase("p") && parentNode.getChildNodes().getLength() == 1;
            } else {
                boolean bl = condition = parentNode.getNodeName().equalsIgnoreCase("p") && parentNode.getChildNodes().getLength() == 1 && part.getTextData().length() == len;
            }
            if (condition) {
                if (this.getApplyingNode().getAttribute("align").equals(((Element)parentNode).getAttribute("align"))) {
                    ((Element)parentNode).removeAttribute("align");
                    DOMPosition startPos = new DOMPosition(parentNode, 0);
                    DOMRefPosition endPos = new DOMRefPosition(endNode, true);
                    return new DOMRange(startPos, endPos);
                }
                String align = this.getApplyingNode().getAttribute("align");
                ((Element)parentNode).setAttribute("align", align);
                DOMPosition startPos = new DOMPosition(parentNode, 0);
                DOMRefPosition endPos = new DOMRefPosition(endNode, true);
                return new DOMRange(startPos, endPos);
            }
        } else if (parentNode != null && parentNode.getNodeName().equalsIgnoreCase("p") && parentNode.getChildNodes().getLength() == len) {
            if (this.getApplyingNode().getAttribute("align").equals(((Element)parentNode).getAttribute("align"))) {
                ((Element)parentNode).removeAttribute("align");
                DOMPosition startPos = new DOMPosition(parentNode, 0);
                DOMRefPosition endPos = new DOMRefPosition(endNode, true);
                return new DOMRange(startPos, endPos);
            }
            String align = this.getApplyingNode().getAttribute("align");
            ((Element)parentNode).setAttribute("align", align);
            DOMPosition startPos = new DOMPosition(parentNode, 0);
            DOMRefPosition endPos = new DOMRefPosition(endNode, true);
            return new DOMRange(startPos, endPos);
        }
        return null;
    }

    private DOMRange InsertStyleTag(DOMRange range) {
        if (range == null || range.isEmpty()) {
            return null;
        }
        boolean ordered = range.isOrdered();
        IDOMPosition start = ordered ? range.getStartPosition() : range.getEndPosition();
        IDOMPosition end = ordered ? range.getEndPosition() : range.getStartPosition();
        Node startContainer = start.getContainerNode();
        Node endContainer = end.getContainerNode();
        Node common = DOMUtil.findCommonAncester(start.getContainerNode(), end.getContainerNode());
        if (common == null) {
            return null;
        }
        if (startContainer instanceof Text) {
            if (start.getOffset() > 0) {
                startContainer = ((Text)startContainer).splitText(start.getOffset());
                start = new DOMRefPosition(startContainer, false);
            }
        } else {
            startContainer = start.getNextSiblingNode();
        }
        if (endContainer instanceof Text) {
            if (end.getOffset() > 0) {
                endContainer = ((Text)endContainer).splitText(end.getOffset());
                endContainer = endContainer.getPreviousSibling();
            } else {
                endContainer = endContainer.getPreviousSibling();
            }
        } else {
            endContainer = end.getPreviousSiblingNode();
        }
        Element newNode = this.createStyleElement();
        startContainer.getParentNode().insertBefore(newNode, startContainer);
        Node sibling = startContainer.getNextSibling();
        newNode.appendChild(startContainer);
        Node endNodeSibling = endContainer.getNextSibling();
        while (sibling != null && startContainer != endContainer && sibling != endNodeSibling) {
            Node tempNode = sibling.getNextSibling();
            newNode.appendChild(sibling);
            sibling = tempNode;
        }
        DOMPosition startPos = new DOMPosition(newNode, 0);
        DOMRefPosition endPos = new DOMRefPosition(endContainer, true);
        return new DOMRange(startPos, endPos);
    }

    private static String getAName(String name) {
        return name == null ? "" : name;
    }
}

