/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer;

import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IAnnotationSerializer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsDefaultsCalculator;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.util.ParamValueComparator;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSerializerAdapter
extends AdapterImpl
implements IAnnotationSerializer {
    private final JaxWsWorkspaceResource resource;
    private final DomUtil util = new DomUtil();
    private final JaxWsDefaultsCalculator defCalc = new JaxWsDefaultsCalculator();

    public AbstractSerializerAdapter(JaxWsWorkspaceResource resource) {
        ContractChecker.nullCheckParam((Object)((Object)resource), (String)"resource");
        this.resource = resource;
    }

    public void notifyChanged(Notification msg) {
        if (!this.resource.isSaveEnabled() || msg.isTouch()) {
            return;
        }
        if (msg.getEventType() != 1 && msg.getEventType() != 2) {
            return;
        }
        if (this.checkValue(msg)) {
            this.save(msg);
        }
    }

    protected boolean checkValue(Notification msg) {
        EObject obj = (EObject)this.getTarget();
        String newValue = this.getNewStringValue(msg);
        if (newValue == null) {
            return this.revertValue(obj, msg);
        }
        this.putValue(obj, (EStructuralFeature)msg.getFeature(), newValue);
        return true;
    }

    @Override
    public void save(Notification msg) {
        boolean processed = false;
        try {
            IAnnotation<? extends IJavaElement> annotation = this.getAnnotation();
            if (annotation == null) {
                return;
            }
            try {
                if (annotation.getParamValuePairs().size() == 0 && !this.isAnnotationRequired()) {
                    this.getAnnotationWriter().remove(annotation);
                } else {
                    this.getAnnotationWriter().update(annotation);
                }
                processed = true;
            }
            catch (AnnotationGeneratorException e) {
                this.logger().logError(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger().logError(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (!processed) {
                this.revertValue((EObject)this.getTarget(), msg);
            }
        }
    }

    protected abstract IAnnotation<? extends IJavaElement> getAnnotation() throws JavaModelException;

    protected abstract boolean isAnnotationRequired();

    public boolean isAdapterForType(Object type) {
        return IAnnotationSerializer.class == type;
    }

    protected JaxWsWorkspaceResource resource() {
        return this.resource;
    }

    protected DomUtil util() {
        return this.util;
    }

    protected JaxWsDefaultsCalculator defCalc() {
        return this.defCalc;
    }

    protected AnnotationWriter getAnnotationWriter() {
        return AnnotationWriter.getInstance();
    }

    protected IParamValuePair createParamValue(String param, String value) {
        IValue iValue = AnnotationFactory.createStringValue((String)value);
        return AnnotationFactory.createParamValuePairValue((String)param, (IValue)iValue);
    }

    protected IParamValuePair createParamValue(String param, boolean value) {
        IValue iValue = AnnotationFactory.createBooleanValue((boolean)value);
        return AnnotationFactory.createParamValuePairValue((String)param, (IValue)iValue);
    }

    protected IType findType(EObject object, String typeFQName) throws JavaModelException {
        EObject webProject = object.eContainer();
        while (!(webProject instanceof IWebServiceProject) && webProject != null) {
            webProject = webProject.eContainer();
        }
        if (webProject == null) {
            return null;
        }
        String projectName = ((IWebServiceProject)webProject).getName();
        IJavaProject javaProject = this.resource.javaModel().getJavaProject(projectName);
        return javaProject.findType(typeFQName);
    }

    protected String getNewStringValue(Notification msg) {
        String newValue;
        String string = newValue = msg.getNewStringValue() == null ? null : msg.getNewStringValue().trim();
        if (newValue != null && newValue.length() > 0) {
            return newValue;
        }
        return null;
    }

    protected boolean revertValue(EObject obj, Notification msg) {
        this.putValue(obj, (EStructuralFeature)msg.getFeature(), msg.getOldValue());
        return false;
    }

    protected void putValue(EObject obj, EStructuralFeature feature, Object newValue) {
        try {
            obj.eSetDeliver(false);
            obj.eSet(feature, newValue);
        }
        finally {
            obj.eSetDeliver(true);
        }
    }

    protected TreeSet<IParamValuePair> createParamValueSortedTreeSet() {
        return new TreeSet<IParamValuePair>(new ParamValueComparator());
    }

    private ILogger logger() {
        return new Logger();
    }
}

